/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.Client$;
import org.apache.spark.deploy.yarn.ExecutorRunnable$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf!B\u0010!\u0001\u0001R\u0003\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011\u001d\u0003!\u0011!Q\u0001\n!C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"Aa\f\u0001B\u0001B\u0003%1\u000b\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003T\u0011!\u0001\u0007A!A!\u0002\u0013\t\u0007\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011B1\t\u0011\u0015\u0004!\u0011!Q\u0001\nMC\u0001B\u001a\u0001\u0003\u0002\u0003\u0006Ia\u001a\u0005\tU\u0002\u0011\t\u0011)A\u0005W\"A\u0011\u000f\u0001B\u0001B\u0003%\u0011\rC\u0003s\u0001\u0011\u00051\u000fC\u0005\u0002\u0006\u0001\u0001\r\u0011\"\u0001\u0002\b!I\u0011Q\u0003\u0001A\u0002\u0013\u0005\u0011q\u0003\u0005\t\u0003G\u0001\u0001\u0015)\u0003\u0002\n!Y\u0011Q\u0005\u0001A\u0002\u0003\u0007I\u0011AA\u0014\u0011-\t9\u0004\u0001a\u0001\u0002\u0004%\t!!\u000f\t\u0017\u0005u\u0002\u00011A\u0001B\u0003&\u0011\u0011\u0006\u0005\b\u0003\u007f\u0001A\u0011AA!\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bBq!a\u0012\u0001\t\u0003\tI\u0005\u0003\u0005\u0002f\u0001!\t\u0001IA4\u0011\u001d\t\u0019\b\u0001C\u0005\u0003kBq!!#\u0001\t\u0013\tYi\u0002\u0005\u0002\u001e\u0002B\t\u0001IAP\r\u001dy\u0002\u0005#\u0001!\u0003CCaA]\u000e\u0005\u0002\u0005\r\u0006BCAS7\t\u0007I\u0011\u0001\u0011\u0002(\"A\u00111W\u000e!\u0002\u0013\tIK\u0001\tFq\u0016\u001cW\u000f^8s%Vtg.\u00192mK*\u0011\u0011EI\u0001\u0005s\u0006\u0014hN\u0003\u0002$I\u00051A-\u001a9m_fT!!\n\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\n\u0004\u0001-\n\u0004C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#AB!osJ+g\r\u0005\u00023k5\t1G\u0003\u00025I\u0005A\u0011N\u001c;fe:\fG.\u0003\u00027g\t9Aj\\4hS:<\u0017!C2p]R\f\u0017N\\3s\u0007\u0001\u00012\u0001\f\u001e=\u0013\tYTF\u0001\u0004PaRLwN\u001c\t\u0003{\u0015k\u0011A\u0010\u0006\u0003\u007f\u0001\u000bqA]3d_J$7O\u0003\u0002B\u0005\u0006\u0019\u0011\r]5\u000b\u0005\u0005\u001a%B\u0001#'\u0003\u0019A\u0017\rZ8pa&\u0011aI\u0010\u0002\n\u0007>tG/Y5oKJ\fAaY8oMB\u0011\u0011jS\u0007\u0002\u0015*\u0011qIQ\u0005\u0003\u0019*\u0013\u0011#W1s]\u000e{gNZ5hkJ\fG/[8o\u0003%\u0019\b/\u0019:l\u0007>tg\r\u0005\u0002P!6\tA%\u0003\u0002RI\tI1\u000b]1sW\u000e{gNZ\u0001\u000e[\u0006\u001cH/\u001a:BI\u0012\u0014Xm]:\u0011\u0005Q[fBA+Z!\t1V&D\u0001X\u0015\tA\u0006(\u0001\u0004=e>|GOP\u0005\u000356\na\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0019\u0019FO]5oO*\u0011!,L\u0001\u000bKb,7-\u001e;pe&#\u0017\u0001\u00035pgRt\u0017-\\3\u0002\u001d\u0015DXmY;u_JlU-\\8ssB\u0011AFY\u0005\u0003G6\u00121!\u00138u\u00035)\u00070Z2vi>\u00148i\u001c:fg\u0006)\u0011\r\u001d9JI\u0006Y1/Z2ve&$\u00180T4s!\ty\u0005.\u0003\u0002jI\ty1+Z2ve&$\u00180T1oC\u001e,'/\u0001\bm_\u000e\fGNU3t_V\u00148-Z:\u0011\tQc7K\\\u0005\u0003[v\u00131!T1q!\tit.\u0003\u0002q}\tiAj\\2bYJ+7o\\;sG\u0016\f\u0011C]3t_V\u00148-\u001a)s_\u001aLG.Z%e\u0003\u0019a\u0014N\\5u}QyAO^<ysj\\H0 @\u0000\u0003\u0003\t\u0019\u0001\u0005\u0002v\u00015\t\u0001\u0005C\u00038\u001b\u0001\u0007\u0011\bC\u0003H\u001b\u0001\u0007\u0001\nC\u0003N\u001b\u0001\u0007a\nC\u0003S\u001b\u0001\u00071\u000bC\u0003_\u001b\u0001\u00071\u000bC\u0003`\u001b\u0001\u00071\u000bC\u0003a\u001b\u0001\u0007\u0011\rC\u0003e\u001b\u0001\u0007\u0011\rC\u0003f\u001b\u0001\u00071\u000bC\u0003g\u001b\u0001\u0007q\rC\u0003k\u001b\u0001\u00071\u000eC\u0003r\u001b\u0001\u0007\u0011-A\u0002sa\u000e,\"!!\u0003\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004C\u0003\rI\u0007oY\u0005\u0005\u0003'\tiAA\u0004ZCJt'\u000bU\"\u0002\u000fI\u00048m\u0018\u0013fcR!\u0011\u0011DA\u0010!\ra\u00131D\u0005\u0004\u0003;i#\u0001B+oSRD\u0011\"!\t\u0010\u0003\u0003\u0005\r!!\u0003\u0002\u0007a$\u0013'\u0001\u0003sa\u000e\u0004\u0013\u0001\u00038n\u00072LWM\u001c;\u0016\u0005\u0005%\u0002\u0003BA\u0016\u0003gi!!!\f\u000b\u0007\u0005\u000byCC\u0002\u00022\t\u000baa\u00197jK:$\u0018\u0002BA\u001b\u0003[\u0011\u0001BT'DY&,g\u000e^\u0001\r]6\u001cE.[3oi~#S-\u001d\u000b\u0005\u00033\tY\u0004C\u0005\u0002\"I\t\t\u00111\u0001\u0002*\u0005Ia.\\\"mS\u0016tG\u000fI\u0001\u0004eVtGCAA\r\u0003Ya\u0017-\u001e8dQ\u000e{g\u000e^3yi\u0012+'-^4J]\u001a|G#A*\u0002\u001dM$\u0018M\u001d;D_:$\u0018-\u001b8feR\u0011\u00111\n\t\b\u0003\u001b\n9fUA-\u001b\t\tyE\u0003\u0003\u0002R\u0005M\u0013\u0001B;uS2T!!!\u0016\u0002\t)\fg/Y\u0005\u0004[\u0006=\u0003\u0003BA.\u0003Cj!!!\u0018\u000b\t\u0005}\u00131K\u0001\u0004]&|\u0017\u0002BA2\u0003;\u0012!BQ=uK\n+hMZ3s\u0003Q\u0019wN\u001c4jOV\u0014XmU3sm&\u001cW\rR1uCR!\u0011\u0011DA5\u0011\u001d\tYg\u0006a\u0001\u0003[\n1a\u0019;y!\ri\u0014qN\u0005\u0004\u0003cr$AF\"p]R\f\u0017N\\3s\u0019\u0006,hn\u00195D_:$X\r\u001f;\u0002\u001dA\u0014X\r]1sK\u000e{W.\\1oIR\u0011\u0011q\u000f\t\u0006\u0003s\n\u0019i\u0015\b\u0005\u0003w\nyHD\u0002W\u0003{J\u0011AL\u0005\u0004\u0003\u0003k\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u000b\u000b9I\u0001\u0003MSN$(bAAA[\u0005\u0011\u0002O]3qCJ,WI\u001c<je>tW.\u001a8u)\t\ti\t\u0005\u0004\u0002\u0010\u0006e5kU\u0007\u0003\u0003#SA!a%\u0002\u0016\u00069Q.\u001e;bE2,'bAAL[\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0015\u0011\u0013\u0002\b\u0011\u0006\u001c\b.T1q\u0003A)\u00050Z2vi>\u0014(+\u001e8oC\ndW\r\u0005\u0002v7M\u00111d\u000b\u000b\u0003\u0003?\u000b!bU#D%\u0016#vlS#Z+\t\tI\u000b\u0005\u0003\u0002,\u0006EVBAAW\u0015\u0011\ty+a\u0015\u0002\t1\fgnZ\u0005\u00049\u00065\u0016aC*F\u0007J+EkX&F3\u0002\u0002")
public class ExecutorRunnable
implements Logging {
    private final Option<Container> container;
    private final YarnConfiguration conf;
    private final SparkConf sparkConf;
    private final String masterAddress;
    private final String executorId;
    private final String hostname;
    private final int executorMemory;
    private final int executorCores;
    private final String appId;
    private final SecurityManager securityMgr;
    private final scala.collection.immutable.Map<String, LocalResource> localResources;
    private final int resourceProfileId;
    private YarnRPC rpc;
    private NMClient nmClient;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public YarnRPC rpc() {
        return this.rpc;
    }

    public void rpc_$eq(YarnRPC x$1) {
        this.rpc = x$1;
    }

    public NMClient nmClient() {
        return this.nmClient;
    }

    public void nmClient_$eq(NMClient x$1) {
        this.nmClient = x$1;
    }

    public void run() {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting Executor Container");
        this.nmClient_$eq(NMClient.createNMClient());
        this.nmClient().init((Configuration)this.conf);
        this.nmClient().start();
        this.startContainer();
    }

    public String launchContextDebugInfo() {
        List<String> commands = this.prepareCommand();
        HashMap<String, String> env = this.prepareEnvironment();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(287).append("\n    |===============================================================================\n    |Default YARN executor launch context:\n    |  env:\n    |").append(((TraversableOnce)Utils$.MODULE$.redact(this.sparkConf, env.toSeq()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new StringBuilder(9).append("    ").append(k).append(" -> ").append(v).append("\n").toString();
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())).mkString()).append("\n    |  command:\n    |    ").append(Utils$.MODULE$.redactCommandLineArgs(this.sparkConf, commands).mkString(" \\ \n      ")).append("\n    |\n    |  resources:\n    |").append(((TraversableOnce)this.localResources.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                LocalResource v = (LocalResource)tuple2._2();
                return new StringBuilder(9).append("    ").append(k).append(" -> ").append(v).append("\n").toString();
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).mkString()).append("\n    |===============================================================================").toString())).stripMargin();
    }

    public Map<String, ByteBuffer> startContainer() {
        Map map;
        ContainerLaunchContext ctx = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        Map env = (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(this.prepareEnvironment()).asJava();
        ctx.setLocalResources((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.localResources).asJava());
        ctx.setEnvironment(env);
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        ctx.setTokens(ByteBuffer.wrap(dob.getData()));
        List<String> commands = this.prepareCommand();
        ctx.setCommands((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(commands).asJava());
        ctx.setApplicationACLs((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(YarnSparkHadoopUtil$.MODULE$.getApplicationAclsForYarn(this.securityMgr)).asJava());
        if (BoxesRunTime.unboxToBoolean((Object)this.sparkConf.get(package$.MODULE$.SHUFFLE_SERVICE_ENABLED()))) {
            this.configureServiceData(ctx);
        }
        try {
            map = this.nmClient().startContainer((Container)this.container.get(), ctx);
        }
        catch (Exception ex) {
            throw new SparkException(new StringBuilder(44).append("Exception while starting container ").append(((Container)this.container.get()).getId()).append(" on host ").append(this.hostname).toString(), (Throwable)ex);
        }
        return map;
    }

    public void configureServiceData(ContainerLaunchContext ctx) {
        String secretString = this.securityMgr.getSecretKey();
        String serviceName = (String)this.sparkConf.get(package$.MODULE$.SHUFFLE_SERVICE_NAME());
        if (!BoxesRunTime.unboxToBoolean((Object)this.sparkConf.get(package$.MODULE$.SHUFFLE_SERVER_RECOVERY_DISABLED()))) {
            ByteBuffer secretBytes = secretString != null ? JavaUtils.stringToBytes((String)secretString) : ByteBuffer.allocate(0);
            ctx.setServiceData(Collections.singletonMap(serviceName, secretBytes));
            return;
        }
        HashMap payload = new HashMap();
        payload.put((Object)package$.MODULE$.SHUFFLE_SERVER_RECOVERY_DISABLED().key(), (Object)Boolean.TRUE);
        Object object = secretString != null ? payload.put((Object)ExecutorRunnable$.MODULE$.SECRET_KEY(), (Object)secretString) : BoxedUnit.UNIT;
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        String jsonString = mapper.writeValueAsString((Object)payload);
        ctx.setServiceData(Collections.singletonMap(serviceName, JavaUtils.stringToBytes((String)jsonString)));
    }

    private List<String> prepareCommand() {
        ListBuffer javaOpts = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        String executorMemoryString = new StringBuilder(1).append(this.executorMemory).append("m").toString();
        javaOpts.$plus$eq((Object)new StringBuilder(4).append("-Xmx").append(executorMemoryString).toString());
        ((Option)this.sparkConf.get((ConfigEntry)package$.MODULE$.EXECUTOR_JAVA_OPTIONS())).foreach((Function1 & Serializable & scala.Serializable)opts -> {
            String subsOpt = Utils$.MODULE$.substituteAppNExecIds(opts, $this.appId, $this.executorId);
            return javaOpts.$plus$plus$eq((TraversableOnce)Utils$.MODULE$.splitCommandString(subsOpt).map((Function1 & Serializable & scala.Serializable)arg -> YarnSparkHadoopUtil$.MODULE$.escapeForShell((String)arg), Seq$.MODULE$.canBuildFrom()));
        });
        Option prefixEnv = ((Option)this.sparkConf.get((ConfigEntry)package$.MODULE$.EXECUTOR_LIBRARY_PATH())).map((Function1 & Serializable & scala.Serializable)libPath -> Client$.MODULE$.createLibraryPathPrefix((String)libPath, $this.sparkConf));
        javaOpts.$plus$eq((Object)new StringBuilder(17).append("-Djava.io.tmpdir=").append(new Path(ApplicationConstants.Environment.PWD.$$(), "./tmp")).toString());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sparkConf.getAll())).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutorRunnable.$anonfun$prepareCommand$4(x0$1))))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return javaOpts.$plus$eq((Object)YarnSparkHadoopUtil$.MODULE$.escapeForShell(new StringBuilder(3).append("-D").append(k).append("=").append(v).toString()));
            }
            throw new MatchError((Object)tuple2);
        });
        javaOpts.$plus$eq((Object)"-Dspark.yarn.app.container.log.dir=<LOG_DIR>");
        YarnSparkHadoopUtil$.MODULE$.addOutOfMemoryErrorArgument((ListBuffer<String>)javaOpts);
        Iterable commands = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)Option$.MODULE$.option2Iterable(prefixEnv).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new StringBuilder(9).append(ApplicationConstants.Environment.JAVA_HOME.$$()).append("/bin/java").toString(), (List)new .colon.colon((Object)"-server", (List)Nil$.MODULE$)), scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)javaOpts, scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"org.apache.spark.executor.YarnCoarseGrainedExecutorBackend", "--driver-url", this.masterAddress, "--executor-id", this.executorId, "--hostname", this.hostname, "--cores", Integer.toString(this.executorCores), "--app-id", this.appId, "--resourceProfileId", Integer.toString(this.resourceProfileId)})), scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new StringBuilder(18).append("1>").append("<LOG_DIR>").append("/stdout").toString(), (List)new .colon.colon((Object)new StringBuilder(18).append("2>").append("<LOG_DIR>").append("/stderr").toString(), (List)Nil$.MODULE$)), scala.collection.Iterable$.MODULE$.canBuildFrom());
        return ((TraversableOnce)commands.map((Function1 & Serializable & scala.Serializable)s -> {
            if (s == null) {
                return "null";
            }
            return s;
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toList();
    }

    private HashMap<String, String> prepareEnvironment() {
        HashMap env = new HashMap();
        Client$.MODULE$.populateClasspath(null, (Configuration)this.conf, this.sparkConf, (HashMap<String, String>)env, (Option<String>)((Option)this.sparkConf.get((ConfigEntry)package$.MODULE$.EXECUTOR_CLASS_PATH())));
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(System.getenv()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("SPARK"))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ExecutorRunnable.$anonfun$prepareEnvironment$2(env, x0$1);
            return BoxedUnit.UNIT;
        });
        this.sparkConf.getExecutorEnv().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ExecutorRunnable.$anonfun$prepareEnvironment$3(env, x0$2);
            return BoxedUnit.UNIT;
        });
        return env;
    }

    public static final /* synthetic */ boolean $anonfun$prepareCommand$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return SparkConf$.MODULE$.isExecutorStartupConf(k);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$prepareEnvironment$2(HashMap env$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            env$1.update((Object)k, (Object)v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$prepareEnvironment$3(HashMap env$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            String string = key;
            String string2 = ApplicationConstants.Environment.CLASSPATH.name();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment((HashMap<String, String>)env$1, key, value);
                return;
            }
            env$1.update((Object)key, (Object)value);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public ExecutorRunnable(Option<Container> container, YarnConfiguration conf, SparkConf sparkConf, String masterAddress, String executorId, String hostname, int executorMemory, int executorCores, String appId, SecurityManager securityMgr, scala.collection.immutable.Map<String, LocalResource> localResources, int resourceProfileId) {
        this.container = container;
        this.conf = conf;
        this.sparkConf = sparkConf;
        this.masterAddress = masterAddress;
        this.executorId = executorId;
        this.hostname = hostname;
        this.executorMemory = executorMemory;
        this.executorCores = executorCores;
        this.appId = appId;
        this.securityMgr = securityMgr;
        this.localResources = localResources;
        this.resourceProfileId = resourceProfileId;
        Logging.$init$((Logging)this);
        this.rpc = YarnRPC.create((Configuration)conf);
    }
}

