/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid.internal;

import com.google.crypto.tink.HybridDecrypt;
import com.google.crypto.tink.hybrid.internal.HpkeAead;
import com.google.crypto.tink.hybrid.internal.HpkeContext;
import com.google.crypto.tink.hybrid.internal.HpkeKdf;
import com.google.crypto.tink.hybrid.internal.HpkeKem;
import com.google.crypto.tink.hybrid.internal.HpkeKemKeyFactory;
import com.google.crypto.tink.hybrid.internal.HpkeKemPrivateKey;
import com.google.crypto.tink.hybrid.internal.HpkePrimitiveFactory;
import com.google.crypto.tink.proto.HpkeParams;
import com.google.crypto.tink.proto.HpkePrivateKey;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.util.Arrays;

@Immutable
final class HpkeDecrypt
implements HybridDecrypt {
    private static final byte[] EMPTY_ASSOCIATED_DATA = new byte[0];
    private final HpkeKemPrivateKey recipientPrivateKey;
    private final HpkeKem kem;
    private final HpkeKdf kdf;
    private final HpkeAead aead;
    private final int encapsulatedKeyLength;

    private HpkeDecrypt(HpkeKemPrivateKey recipientPrivateKey, HpkeKem kem, HpkeKdf kdf, HpkeAead aead, int encapsulatedKeyLength) {
        this.recipientPrivateKey = recipientPrivateKey;
        this.kem = kem;
        this.kdf = kdf;
        this.aead = aead;
        this.encapsulatedKeyLength = encapsulatedKeyLength;
    }

    private static int encodingSizeInBytes(com.google.crypto.tink.proto.HpkeKem kemProtoEnum) {
        switch (kemProtoEnum) {
            case DHKEM_X25519_HKDF_SHA256: {
                return 32;
            }
            case DHKEM_P256_HKDF_SHA256: {
                return 65;
            }
            case DHKEM_P384_HKDF_SHA384: {
                return 97;
            }
            case DHKEM_P521_HKDF_SHA512: {
                return 133;
            }
        }
        throw new IllegalArgumentException("Unable to determine KEM-encoding length for " + kemProtoEnum.name());
    }

    static HpkeDecrypt createHpkeDecrypt(HpkePrivateKey recipientPrivateKey) throws GeneralSecurityException {
        if (!recipientPrivateKey.hasPublicKey()) {
            throw new IllegalArgumentException("HpkePrivateKey is missing public_key field.");
        }
        if (!recipientPrivateKey.getPublicKey().hasParams()) {
            throw new IllegalArgumentException("HpkePrivateKey.public_key is missing params field.");
        }
        if (recipientPrivateKey.getPrivateKey().isEmpty()) {
            throw new IllegalArgumentException("HpkePrivateKey.private_key is empty.");
        }
        HpkeParams params = recipientPrivateKey.getPublicKey().getParams();
        HpkeKem kem = HpkePrimitiveFactory.createKem(params);
        HpkeKdf kdf = HpkePrimitiveFactory.createKdf(params);
        HpkeAead aead = HpkePrimitiveFactory.createAead(params);
        int encapsulatedKeyLength = HpkeDecrypt.encodingSizeInBytes(params.getKem());
        HpkeKemPrivateKey recipientKemPrivateKey = HpkeKemKeyFactory.createPrivate(recipientPrivateKey);
        return new HpkeDecrypt(recipientKemPrivateKey, kem, kdf, aead, encapsulatedKeyLength);
    }

    @Override
    public byte[] decrypt(byte[] ciphertext, byte[] contextInfo) throws GeneralSecurityException {
        if (ciphertext.length < this.encapsulatedKeyLength) {
            throw new GeneralSecurityException("Ciphertext is too short.");
        }
        byte[] info = contextInfo;
        if (info == null) {
            info = new byte[]{};
        }
        byte[] encapsulatedKey = Arrays.copyOf(ciphertext, this.encapsulatedKeyLength);
        byte[] aeadCiphertext = Arrays.copyOfRange(ciphertext, this.encapsulatedKeyLength, ciphertext.length);
        HpkeContext context = HpkeContext.createRecipientContext(encapsulatedKey, this.recipientPrivateKey, this.kem, this.kdf, this.aead, info);
        return context.open(aeadCiphertext, EMPTY_ASSOCIATED_DATA);
    }
}

