/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat;

import java.io.Serializable;
import org.apache.spark.api.java.JavaDoubleRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.mllib.stat.correlation.Correlations$;
import org.apache.spark.mllib.stat.test.ChiSqTest$;
import org.apache.spark.mllib.stat.test.ChiSqTestResult;
import org.apache.spark.mllib.stat.test.KolmogorovSmirnovTest$;
import org.apache.spark.mllib.stat.test.KolmogorovSmirnovTestResult;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;

public final class Statistics$ {
    public static Statistics$ MODULE$;

    static {
        new Statistics$();
    }

    public KolmogorovSmirnovTestResult kolmogorovSmirnovTest(RDD<Object> data, String distName, double ... params) {
        return this.kolmogorovSmirnovTest(data, distName, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(params));
    }

    public KolmogorovSmirnovTestResult kolmogorovSmirnovTest(JavaDoubleRDD data, String distName, double ... params) {
        return this.kolmogorovSmirnovTest(data, distName, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(params));
    }

    public MultivariateStatisticalSummary colStats(RDD<Vector> X) {
        return new RowMatrix(X).computeColumnSummaryStatistics();
    }

    public SummarizerBuffer colStats(RDD<Tuple2<Vector, Object>> X, Seq<String> requested) {
        return (SummarizerBuffer)X.treeAggregate((Object)Summarizer$.MODULE$.createSummarizerBuffer(requested), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                SummarizerBuffer c = (SummarizerBuffer)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Vector v = (Vector)tuple22._1();
                    double w = tuple22._2$mcD$sp();
                    return c.add(v.nonZeroIterator(), v.size(), w);
                }
            }
            throw new MatchError((Object)tuple2);
        }, (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
            if (tuple2 != null) {
                SummarizerBuffer c1 = (SummarizerBuffer)tuple2._1();
                SummarizerBuffer c2 = (SummarizerBuffer)tuple2._2();
                return c1.merge(c2);
            }
            throw new MatchError((Object)tuple2);
        }, 2, ClassTag$.MODULE$.apply(SummarizerBuffer.class));
    }

    public Matrix corr(RDD<Vector> X) {
        return Correlations$.MODULE$.corrMatrix(X, Correlations$.MODULE$.corrMatrix$default$2());
    }

    public Matrix corr(RDD<Vector> X, String method) {
        return Correlations$.MODULE$.corrMatrix(X, method);
    }

    public double corr(RDD<Object> x, RDD<Object> y) {
        return Correlations$.MODULE$.corr(x, y, Correlations$.MODULE$.corr$default$3());
    }

    public double corr(JavaRDD<Double> x, JavaRDD<Double> y) {
        return this.corr((RDD<Object>)x.rdd(), (RDD<Object>)y.rdd());
    }

    public double corr(RDD<Object> x, RDD<Object> y, String method) {
        return Correlations$.MODULE$.corr(x, y, method);
    }

    public double corr(JavaRDD<Double> x, JavaRDD<Double> y, String method) {
        return this.corr((RDD<Object>)x.rdd(), (RDD<Object>)y.rdd(), method);
    }

    public ChiSqTestResult chiSqTest(Vector observed, Vector expected) {
        return ChiSqTest$.MODULE$.chiSquared(observed, expected, ChiSqTest$.MODULE$.chiSquared$default$3());
    }

    public ChiSqTestResult chiSqTest(Vector observed) {
        return ChiSqTest$.MODULE$.chiSquared(observed, ChiSqTest$.MODULE$.chiSquared$default$2(), ChiSqTest$.MODULE$.chiSquared$default$3());
    }

    public ChiSqTestResult chiSqTest(Matrix observed) {
        return ChiSqTest$.MODULE$.chiSquaredMatrix(observed, ChiSqTest$.MODULE$.chiSquaredMatrix$default$2());
    }

    public ChiSqTestResult[] chiSqTest(RDD<LabeledPoint> data) {
        return ChiSqTest$.MODULE$.chiSquaredFeatures(data, ChiSqTest$.MODULE$.chiSquaredFeatures$default$2());
    }

    public ChiSqTestResult[] chiSqTest(JavaRDD<LabeledPoint> data) {
        return this.chiSqTest((RDD<LabeledPoint>)data.rdd());
    }

    public KolmogorovSmirnovTestResult kolmogorovSmirnovTest(RDD<Object> data, Function1<Object, Object> cdf) {
        return KolmogorovSmirnovTest$.MODULE$.testOneSample(data, cdf);
    }

    public KolmogorovSmirnovTestResult kolmogorovSmirnovTest(RDD<Object> data, String distName, Seq<Object> params) {
        return KolmogorovSmirnovTest$.MODULE$.testOneSample(data, distName, params);
    }

    public KolmogorovSmirnovTestResult kolmogorovSmirnovTest(JavaDoubleRDD data, String distName, Seq<Object> params) {
        return this.kolmogorovSmirnovTest((RDD<Object>)data.rdd(), distName, params);
    }

    private Statistics$() {
        MODULE$ = this;
    }
}

