/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.rdd;

import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.random.RandomDataGenerator;
import org.apache.spark.mllib.rdd.RandomRDD$;
import org.apache.spark.mllib.rdd.RandomRDDPartition;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ee!\u0002\u000b\u0016\u0001]y\u0002\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\t\u0011i\u0002!\u0011!Q\u0001\nmB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u0005\u0002\u0011)\u0019!C\u0005\u0007\"A!\n\u0001B\u0001B\u0003%A\t\u0003\u0005P\u0001\t\u0015\r\u0011\"\u0003Q\u0011!\t\u0006A!A!\u0002\u0013Y\u0004\u0002C*\u0001\u0005\u0007\u0005\u000b1\u0002+\t\u000bi\u0003A\u0011A.\t\u000b\u0015\u0004A\u0011\t4\t\u000bu\u0004A\u0011\t@\b\u0011\u0005\u0015Q\u0003#\u0001\u0018\u0003\u000f1q\u0001F\u000b\t\u0002]\tI\u0001\u0003\u0004[\u001b\u0011\u0005\u0011q\u0003\u0005\u0007{6!\t!!\u0007\t\u000f\u0005-R\u0002\"\u0001\u0002.!9\u0011\u0011J\u0007\u0005\u0002\u0005-\u0003\"CA5\u001bE\u0005I\u0011AA6\u0011%\t))DA\u0001\n\u0013\t9IA\u0005SC:$w.\u001c*E\t*\u0011acF\u0001\u0004e\u0012$'B\u0001\r\u001a\u0003\u0015iG\u000e\\5c\u0015\tQ2$A\u0003ta\u0006\u00148N\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<WC\u0001\u0011)'\t\u0001\u0011\u0005E\u0002#I\u0019j\u0011a\t\u0006\u0003-eI!!J\u0012\u0003\u0007I#E\t\u0005\u0002(Q1\u0001A!B\u0015\u0001\u0005\u0004Y#!\u0001+\u0004\u0001E\u0011AF\r\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\b\u001d>$\b.\u001b8h!\ti3'\u0003\u00025]\t\u0019\u0011I\\=\u0002\u0005M\u001c\u0007CA\u001c9\u001b\u0005I\u0012BA\u001d\u001a\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0003\u0011\u0019\u0018N_3\u0011\u00055b\u0014BA\u001f/\u0005\u0011auN\\4\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t!\ti\u0003)\u0003\u0002B]\t\u0019\u0011J\u001c;\u0002\u0007Itw-F\u0001E!\r)\u0005JJ\u0007\u0002\r*\u0011qiF\u0001\u0007e\u0006tGm\\7\n\u0005%3%a\u0005*b]\u0012|W\u000eR1uC\u001e+g.\u001a:bi>\u0014\u0018\u0001\u0002:oO\u0002B#!\u0002'\u0011\u00055j\u0015B\u0001(/\u0005%!(/\u00198tS\u0016tG/\u0001\u0003tK\u0016$W#A\u001e\u0002\u000bM,W\r\u001a\u0011)\u0005\u001da\u0015AC3wS\u0012,gnY3%cA\u0019Q\u000b\u0017\u0014\u000e\u0003YS!a\u0016\u0018\u0002\u000fI,g\r\\3di&\u0011\u0011L\u0016\u0002\t\u00072\f7o\u001d+bO\u00061A(\u001b8jiz\"b\u0001\u00181bE\u000e$GCA/`!\rq\u0006AJ\u0007\u0002+!)1+\u0003a\u0002)\")Q'\u0003a\u0001m!)!(\u0003a\u0001w!)a(\u0003a\u0001\u007f!)!)\u0003a\u0001\t\"9q*\u0003I\u0001\u0002\u0004Y\u0014aB2p[B,H/\u001a\u000b\u0004OND\bc\u00015qM9\u0011\u0011N\u001c\b\u0003U6l\u0011a\u001b\u0006\u0003Y*\na\u0001\u0010:p_Rt\u0014\"A\u0018\n\u0005=t\u0013a\u00029bG.\fw-Z\u0005\u0003cJ\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003_:BQ\u0001\u001e\u0006A\u0002U\fqa\u001d9mSRLe\u000e\u0005\u00028m&\u0011q/\u0007\u0002\n!\u0006\u0014H/\u001b;j_:DQ!\u001f\u0006A\u0002i\fqaY8oi\u0016DH\u000f\u0005\u00028w&\u0011A0\u0007\u0002\f)\u0006\u001c8nQ8oi\u0016DH/A\u0007hKR\u0004\u0016M\u001d;ji&|gn]\u000b\u0002\u007fB!Q&!\u0001v\u0013\r\t\u0019A\f\u0002\u0006\u0003J\u0014\u0018-_\u0001\n%\u0006tGm\\7S\t\u0012\u0003\"AX\u0007\u0014\u000b5\tY!!\u0005\u0011\u00075\ni!C\u0002\u0002\u00109\u0012a!\u00118z%\u00164\u0007cA\u0017\u0002\u0014%\u0019\u0011Q\u0003\u0018\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\u0005\u001dQ\u0003BA\u000e\u0003O!\u0012b`A\u000f\u0003?\t\t#!\u000b\t\u000biz\u0001\u0019A\u001e\t\u000byz\u0001\u0019A \t\r\t{\u0001\u0019AA\u0012!\u0011)\u0005*!\n\u0011\u0007\u001d\n9\u0003B\u0003*\u001f\t\u00071\u0006C\u0003P\u001f\u0001\u00071(\u0001\thKR\u0004v.\u001b8u\u0013R,'/\u0019;peV!\u0011qFA\u001c)\u0011\t\t$a\u0010\u0015\t\u0005M\u0012\u0011\b\t\u0005QB\f)\u0004E\u0002(\u0003o!Q!\u000b\tC\u0002-B\u0011\"a\u000f\u0011\u0003\u0003\u0005\u001d!!\u0010\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007\u0005\u0003V1\u0006U\u0002bBA!!\u0001\u0007\u00111I\u0001\na\u0006\u0014H/\u001b;j_:\u0004RAXA#\u0003kI1!a\u0012\u0016\u0005I\u0011\u0016M\u001c3p[J#E\tU1si&$\u0018n\u001c8\u0002#\u001d,GOV3di>\u0014\u0018\n^3sCR|'\u000f\u0006\u0004\u0002N\u0005m\u0013Q\r\t\u0005QB\fy\u0005\u0005\u0003\u0002R\u0005]SBAA*\u0015\r\t)fF\u0001\u0007Y&t\u0017\r\\4\n\t\u0005e\u00131\u000b\u0002\u0007-\u0016\u001cGo\u001c:\t\u000f\u0005\u0005\u0013\u00031\u0001\u0002^A)a,!\u0012\u0002`A\u0019Q&!\u0019\n\u0007\u0005\rdF\u0001\u0004E_V\u0014G.\u001a\u0005\u0007\u0003O\n\u0002\u0019A \u0002\u0015Y,7\r^8s'&TX-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0005\u0003[\n\u0019)\u0006\u0002\u0002p)\u001a1(!\u001d,\u0005\u0005M\u0004\u0003BA;\u0003\u007fj!!a\u001e\u000b\t\u0005e\u00141P\u0001\nk:\u001c\u0007.Z2lK\u0012T1!! /\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0003\u000b9HA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$Q!\u000b\nC\u0002-\n1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0012\t\u0005\u0003\u0017\u000b)*\u0004\u0002\u0002\u000e*!\u0011qRAI\u0003\u0011a\u0017M\\4\u000b\u0005\u0005M\u0015\u0001\u00026bm\u0006LA!a&\u0002\u000e\n1qJ\u00196fGR\u0004")
public class RandomRDD<T>
extends RDD<T> {
    private final long size;
    private final int numPartitions;
    private final transient RandomDataGenerator<T> rng;
    private final transient long seed;
    private final ClassTag<T> evidence$1;

    public static <T> long $lessinit$greater$default$5() {
        return RandomRDD$.MODULE$.$lessinit$greater$default$5();
    }

    public static Iterator<Vector> getVectorIterator(RandomRDDPartition<Object> randomRDDPartition, int n) {
        return RandomRDD$.MODULE$.getVectorIterator(randomRDDPartition, n);
    }

    public static <T> Iterator<T> getPointIterator(RandomRDDPartition<T> randomRDDPartition, ClassTag<T> classTag) {
        return RandomRDD$.MODULE$.getPointIterator(randomRDDPartition, classTag);
    }

    private RandomDataGenerator<T> rng() {
        return this.rng;
    }

    private long seed() {
        return this.seed;
    }

    public Iterator<T> compute(Partition splitIn, TaskContext context) {
        RandomRDDPartition split = (RandomRDDPartition)splitIn;
        return RandomRDD$.MODULE$.getPointIterator(split, this.evidence$1);
    }

    public Partition[] getPartitions() {
        return RandomRDD$.MODULE$.getPartitions(this.size, this.numPartitions, this.rng(), this.seed());
    }

    public RandomRDD(SparkContext sc, long size, int numPartitions, RandomDataGenerator<T> rng, long seed, ClassTag<T> evidence$1) {
        this.size = size;
        this.numPartitions = numPartitions;
        this.rng = rng;
        this.seed = seed;
        this.evidence$1 = evidence$1;
        super(sc, (Seq)Nil$.MODULE$, evidence$1);
        Predef$.MODULE$.require(size > 0L, (Function0 & java.io.Serializable & Serializable)() -> "Positive RDD size required.");
        Predef$.MODULE$.require(numPartitions > 0, (Function0 & java.io.Serializable & Serializable)() -> "Positive number of partitions required");
        Predef$.MODULE$.require(package$.MODULE$.ceil((double)size / (double)numPartitions) <= (double)Integer.MAX_VALUE, (Function0 & java.io.Serializable & Serializable)() -> "Partition size cannot exceed Int.MaxValue");
    }
}

