/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.Serializable;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.NominalAttribute$;
import org.apache.spark.ml.attribute.NumericAttribute$;
import org.apache.spark.ml.feature.UnivariateFeatureSelectorModel;
import org.apache.spark.ml.feature.UnivariateFeatureSelectorModel$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.DenseVector$;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.SparseVector$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

public final class UnivariateFeatureSelectorModel$
implements MLReadable<UnivariateFeatureSelectorModel>,
scala.Serializable {
    public static UnivariateFeatureSelectorModel$ MODULE$;

    static {
        new UnivariateFeatureSelectorModel$();
    }

    @Override
    public MLReader<UnivariateFeatureSelectorModel> read() {
        return new UnivariateFeatureSelectorModel.UnivariateFeatureSelectorModelReader();
    }

    @Override
    public UnivariateFeatureSelectorModel load(String path) {
        return (UnivariateFeatureSelectorModel)MLReadable.load$(this, path);
    }

    public Dataset<Row> org$apache$spark$ml$feature$UnivariateFeatureSelectorModel$$transform(Dataset<?> dataset, int[] selectedFeatures, StructType outputSchema, String outputCol, String featuresCol) {
        int newSize = selectedFeatures.length;
        Function1 & Serializable & scala.Serializable func = (Function1 & Serializable & scala.Serializable)vector -> {
            DenseVector denseVector;
            Option option;
            SparseVector sparseVector;
            Option option2;
            Vector vector2 = vector;
            if (vector2 instanceof SparseVector && !(option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector2)).isEmpty()) {
                double[] values;
                int[] indices = (int[])((Tuple3)option2.get())._2();
                Tuple2<int[], double[]> tuple2 = MODULE$.compressSparse(indices, values = (double[])((Tuple3)option2.get())._3(), selectedFeatures);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int[] newIndices = (int[])tuple2._1();
                double[] newValues = (double[])tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)newIndices, (Object)newValues);
                int[] newIndices2 = (int[])tuple22._1();
                double[] newValues2 = (double[])tuple22._2();
                return Vectors$.MODULE$.sparse(newSize, newIndices2, newValues2);
            }
            if (vector2 instanceof DenseVector && !(option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector2)).isEmpty()) {
                double[] values = (double[])option.get();
                return Vectors$.MODULE$.dense((double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(selectedFeatures)).map((Function1)Predef$.MODULE$.wrapDoubleArray(values), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            }
            throw new UnsupportedOperationException(new StringBuilder(53).append("Only sparse and dense vectors are supported but got ").append(vector2.getClass()).append(".").toString());
        };
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_feature_UnivariateFeatureSelectorModel$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_feature_UnivariateFeatureSelectorModel$$typecreator1$2() {
            }
        }
        public final class Org_apache_spark_ml_feature_UnivariateFeatureSelectorModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_feature_UnivariateFeatureSelectorModel$$typecreator2$1() {
            }
        }
        UserDefinedFunction transformer = functions$.MODULE$.udf((Function1)func, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_UnivariateFeatureSelectorModel$$typecreator1$2()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_UnivariateFeatureSelectorModel$$typecreator2$1()));
        return dataset.withColumn(outputCol, transformer.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(featuresCol)})), outputSchema.apply(outputCol).metadata());
    }

    public StructField org$apache$spark$ml$feature$UnivariateFeatureSelectorModel$$prepOutputField(StructType schema, int[] selectedFeatures, String outputCol, String featuresCol, boolean isNumericAttribute) {
        Set selector = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(selectedFeatures)).toSet();
        AttributeGroup origAttrGroup = AttributeGroup$.MODULE$.fromStructField(schema.apply(featuresCol));
        Attribute[] featureAttributes = origAttrGroup.attributes().nonEmpty() ? (Attribute[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])origAttrGroup.attributes().get())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)selector.contains((Object)BoxesRunTime.boxToInteger((int)x._2$mcI$sp())))))).map((Function1 & Serializable & scala.Serializable)x$2 -> (Attribute)x$2._1(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class))) : (isNumericAttribute ? (Attribute[])Array$.MODULE$.fill(selector.size(), (Function0 & Serializable & scala.Serializable)() -> NumericAttribute$.MODULE$.defaultAttr(), ClassTag$.MODULE$.apply(Attribute.class)) : (Attribute[])Array$.MODULE$.fill(selector.size(), (Function0 & Serializable & scala.Serializable)() -> NominalAttribute$.MODULE$.defaultAttr(), ClassTag$.MODULE$.apply(Attribute.class)));
        AttributeGroup newAttributeGroup = new AttributeGroup(outputCol, featureAttributes);
        return newAttributeGroup.toStructField();
    }

    private Tuple2<int[], double[]> compressSparse(int[] indices, double[] values, int[] selectedFeatures) {
        ArrayBuilder.ofDouble newValues = new ArrayBuilder.ofDouble();
        ArrayBuilder.ofInt newIndices = new ArrayBuilder.ofInt();
        int i = 0;
        int j = 0;
        while (i < indices.length && j < selectedFeatures.length) {
            int indicesIdx = indices[i];
            int filterIndicesIdx = selectedFeatures[j];
            if (indicesIdx == filterIndicesIdx) {
                newIndices.$plus$eq(j);
                newValues.$plus$eq(values[i]);
                ++j;
                ++i;
                continue;
            }
            if (indicesIdx > filterIndicesIdx) {
                ++j;
                continue;
            }
            ++i;
        }
        return new Tuple2((Object)newIndices.result(), (Object)newValues.result());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private UnivariateFeatureSelectorModel$() {
        MODULE$ = this;
        MLReadable.$init$(this);
    }
}

