/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.GaussianMixtureModel$;
import org.apache.spark.ml.clustering.GaussianMixtureModel$GaussianMixtureModelWriter$;
import org.apache.spark.ml.clustering.GaussianMixtureModel$GaussianMixtureModelWriter$Data$;
import org.apache.spark.ml.clustering.GaussianMixtureParams;
import org.apache.spark.ml.clustering.GaussianMixtureSummary;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasProbabilityCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.stat.distribution.MultivariateGaussian;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r5d\u0001B A\u0001-C\u0001\"\u0019\u0001\u0003\u0006\u0004%\tE\u0019\u0005\ts\u0002\u0011\t\u0011)A\u0005G\"A1\u0010\u0001BC\u0002\u0013\u0005A\u0010C\u0005\u0002\f\u0001\u0011\t\u0011)A\u0005{\"Q\u0011q\u0002\u0001\u0003\u0006\u0004%\t!!\u0005\t\u0015\u0005\u001d\u0002A!A!\u0002\u0013\t\u0019\u0002\u0003\u0005\u0002,\u0001!\tAQA\u0017\u0011)\tY\u0004\u0001EC\u0002\u0013\u0005\u0011Q\b\u0005\b\u0003\u0017\u0002A\u0011AA'\u0011\u001d\tY\u0006\u0001C\u0001\u0003;Bq!a\u0019\u0001\t\u0003\t)\u0007C\u0004\u0002l\u0001!\t%!\u001c\t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\"9\u0011Q\u001a\u0001\u0005B\u0005=\u0007bBAr\u0001\u0011\u0005\u0011Q\u001d\u0005\b\u0003s\u0004A\u0011AA~\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0005\u0007AqAa\u0002\u0001\t\u0003\u0012I\u0001C\u0004\u0003\u0014\u0001!\tE!\u0006\t\u000f\te\u0001\u0001\"\u0011\u0003\u001c\u001d9!\u0011\u0005!\t\u0002\t\rbAB A\u0011\u0003\u0011)\u0003C\u0004\u0002,Y!\tA!\u000f\t\u000f\tmb\u0003\"\u0011\u0003>!9!q\t\f\u0005B\t%ca\u0002B)-\u00011\"1\u000b\u0005\n\u0005+R\"\u0011!Q\u0001\nACq!a\u000b\u001b\t\u0003\u00119F\u0002\u0004\u0003`i!%\u0011\r\u0005\twv\u0011)\u001a!C\u0001y\"I\u00111B\u000f\u0003\u0012\u0003\u0006I! \u0005\u000b\u0005Sj\"Q3A\u0005\u0002\t-\u0004B\u0003B>;\tE\t\u0015!\u0003\u0003n!Q!QP\u000f\u0003\u0016\u0004%\tAa \t\u0015\t%UD!E!\u0002\u0013\u0011\t\tC\u0004\u0002,u!\tAa#\t\u0013\u0005-T$!A\u0005\u0002\t]\u0005\"\u0003BP;E\u0005I\u0011\u0001BQ\u0011%\u0011),HI\u0001\n\u0003\u00119\fC\u0005\u0003<v\t\n\u0011\"\u0001\u0003>\"I!\u0011Y\u000f\u0002\u0002\u0013\u0005#1\u0019\u0005\n\u0005'l\u0012\u0011!C\u0001\u0003{A\u0011B!6\u001e\u0003\u0003%\tAa6\t\u0013\tuW$!A\u0005B\t}\u0007\"\u0003Bw;\u0005\u0005I\u0011\u0001Bx\u0011%\u0011I0HA\u0001\n\u0003\u0012Y\u0010C\u0005\u0003\u0014u\t\t\u0011\"\u0011\u0003~\"I!q`\u000f\u0002\u0002\u0013\u00053\u0011A\u0004\n\u0007\u000bQ\u0012\u0011!E\u0005\u0007\u000f1\u0011Ba\u0018\u001b\u0003\u0003EIa!\u0003\t\u000f\u0005-\"\u0007\"\u0001\u0004\u0018!I!1\u0003\u001a\u0002\u0002\u0013\u0015#Q \u0005\n\u00073\u0011\u0014\u0011!CA\u00077A\u0011ba\t3\u0003\u0003%\ti!\n\t\u000f\r]\"\u0004\"\u0015\u0004:\u0019111\t\f\u0005\u0007\u000bBq!a\u000b9\t\u0003\u00199\u0005C\u0005\u0004La\u0012\r\u0011\"\u0003\u0003D\"A1Q\n\u001d!\u0002\u0013\u0011)\rC\u0004\u0003Ha\"\tea\u0014\t\u0011\rMc\u0003\"\u0001A\u0007+B\u0011ba\u0018\u0017\u0003\u0003%Ia!\u0019\u0003)\u001d\u000bWo]:jC:l\u0015\u000e\u001f;ve\u0016lu\u000eZ3m\u0015\t\t%)\u0001\u0006dYV\u001cH/\u001a:j]\u001eT!a\u0011#\u0002\u00055d'BA#G\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0005*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0006\u0019qN]4\u0004\u0001M)\u0001\u0001\u0014*V7B\u0019QJ\u0014)\u000e\u0003\tK!a\u0014\"\u0003\u000b5{G-\u001a7\u0011\u0005E\u0003Q\"\u0001!\u0011\u0005E\u001b\u0016B\u0001+A\u0005U9\u0015-^:tS\u0006tW*\u001b=ukJ,\u0007+\u0019:b[N\u0004\"AV-\u000e\u0003]S!\u0001\u0017\"\u0002\tU$\u0018\u000e\\\u0005\u00035^\u0013!\"\u0014'Xe&$\u0018M\u00197f!\r1FLX\u0005\u0003;^\u0013!\u0003S1t)J\f\u0017N\\5oON+X.\\1ssB\u0011\u0011kX\u0005\u0003A\u0002\u0013acR1vgNL\u0017M\\'jqR,(/Z*v[6\f'/_\u0001\u0004k&$W#A2\u0011\u0005\u0011lgBA3l!\t1\u0017.D\u0001h\u0015\tA'*\u0001\u0004=e>|GO\u0010\u0006\u0002U\u0006)1oY1mC&\u0011A.[\u0001\u0007!J,G-\u001a4\n\u00059|'AB*ue&twM\u0003\u0002mS\"\u001a\u0011!]<\u0011\u0005I,X\"A:\u000b\u0005Q$\u0015AC1o]>$\u0018\r^5p]&\u0011ao\u001d\u0002\u0006'&t7-Z\u0011\u0002q\u0006)!G\f\u0019/a\u0005!Q/\u001b3!Q\r\u0011\u0011o^\u0001\bo\u0016Lw\r\u001b;t+\u0005i\b\u0003\u0002@\u0000\u0003\u0007i\u0011![\u0005\u0004\u0003\u0003I'!B!se\u0006L\bc\u0001@\u0002\u0006%\u0019\u0011qA5\u0003\r\u0011{WO\u00197fQ\r\u0019\u0011o^\u0001\to\u0016Lw\r\u001b;tA!\u001aA!]<\u0002\u0013\u001d\fWo]:jC:\u001cXCAA\n!\u0011qx0!\u0006\u0011\t\u0005]\u0011\u0011E\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005aA-[:ue&\u0014W\u000f^5p]*\u0019\u0011q\u0004\"\u0002\tM$\u0018\r^\u0005\u0005\u0003G\tIB\u0001\u000bNk2$\u0018N^1sS\u0006$XmR1vgNL\u0017M\u001c\u0015\u0004\u000bE<\u0018AC4bkN\u001c\u0018.\u00198tA!\u001aa!]<\u0002\rqJg.\u001b;?)\u001d\u0001\u0016qFA\u001a\u0003oAQ!Y\u0004A\u0002\rDC!a\fro\")1p\u0002a\u0001{\"\"\u00111G9x\u0011\u001d\tya\u0002a\u0001\u0003'AC!a\u000ero\u0006Ya.^7GK\u0006$XO]3t+\t\ty\u0004E\u0002\u007f\u0003\u0003J1!a\u0011j\u0005\rIe\u000e\u001e\u0015\u0005\u0011E\f9%\t\u0002\u0002J\u0005)1G\f\u0019/a\u0005q1/\u001a;GK\u0006$XO]3t\u0007>dG\u0003BA(\u0003#j\u0011\u0001\u0001\u0005\u0007\u0003'J\u0001\u0019A2\u0002\u000bY\fG.^3)\t%\t\u0018qK\u0011\u0003\u00033\nQA\r\u00182]A\n\u0001c]3u!J,G-[2uS>t7i\u001c7\u0015\t\u0005=\u0013q\f\u0005\u0007\u0003'R\u0001\u0019A2)\t)\t\u0018qK\u0001\u0012g\u0016$\bK]8cC\nLG.\u001b;z\u0007>dG\u0003BA(\u0003OBa!a\u0015\f\u0001\u0004\u0019\u0007\u0006B\u0006r\u0003/\nAaY8qsR\u0019\u0001+a\u001c\t\u000f\u0005ED\u00021\u0001\u0002t\u0005)Q\r\u001f;sCB!\u0011QOA>\u001b\t\t9HC\u0002\u0002z\t\u000bQ\u0001]1sC6LA!! \u0002x\tA\u0001+\u0019:b[6\u000b\u0007\u000fK\u0002\rc^\f\u0011\u0002\u001e:b]N4wN]7\u0015\t\u0005\u0015\u0015q\u0015\t\u0005\u0003\u000f\u000b\tK\u0004\u0003\u0002\n\u0006me\u0002BAF\u0003/sA!!$\u0002\u0016:!\u0011qRAJ\u001d\r1\u0017\u0011S\u0005\u0002\u0013&\u0011q\tS\u0005\u0003\u000b\u001aK1!!'E\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003;\u000by*A\u0004qC\u000e\\\u0017mZ3\u000b\u0007\u0005eE)\u0003\u0003\u0002$\u0006\u0015&!\u0003#bi\u00064%/Y7f\u0015\u0011\ti*a(\t\u000f\u0005%V\u00021\u0001\u0002,\u00069A-\u0019;bg\u0016$\b\u0007BAW\u0003s\u0003b!a,\u00022\u0006UVBAAP\u0013\u0011\t\u0019,a(\u0003\u000f\u0011\u000bG/Y:fiB!\u0011qWA]\u0019\u0001!A\"a/\u0002(\u0006\u0005\t\u0011!B\u0001\u0003{\u00131a\u0018\u00132#\u0011\ty,!2\u0011\u0007y\f\t-C\u0002\u0002D&\u0014qAT8uQ&tw\rE\u0002\u007f\u0003\u000fL1!!3j\u0005\r\te.\u001f\u0015\u0004\u001bE<\u0018a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\t\u0005E\u0017Q\u001c\t\u0005\u0003'\fI.\u0004\u0002\u0002V*!\u0011q[AP\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tY.!6\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0002`:\u0001\r!!5\u0002\rM\u001c\u0007.Z7bQ\rq\u0011o^\u0001\baJ,G-[2u)\u0011\ty$a:\t\u000f\u0005%x\u00021\u0001\u0002l\u0006Aa-Z1ukJ,7\u000f\u0005\u0003\u0002n\u0006MXBAAx\u0015\r\t\tPQ\u0001\u0007Y&t\u0017\r\\4\n\t\u0005U\u0018q\u001e\u0002\u0007-\u0016\u001cGo\u001c:)\t=\t\u0018qI\u0001\u0013aJ,G-[2u!J|'-\u00192jY&$\u0018\u0010\u0006\u0003\u0002l\u0006u\bbBAu!\u0001\u0007\u00111\u001e\u0015\u0005!E\f9%A\u0006hCV\u001c8/[1og\u00123UCAACQ\r\t\u0012o^\u0001\u0006oJLG/Z\u000b\u0003\u0005\u0017\u00012A\u0016B\u0007\u0013\r\u0011ya\u0016\u0002\t\u001b2;&/\u001b;fe\"\u001a!#]<\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u0019\u0015\u0005'E\f9%A\u0004tk6l\u0017M]=\u0016\u0003yC3\u0001F9xQ\r\u0001\u0011o^\u0001\u0015\u000f\u0006,8o]5b]6K\u0007\u0010^;sK6{G-\u001a7\u0011\u0005E32c\u0002\f\u0003(\t5\"1\u0007\t\u0004}\n%\u0012b\u0001B\u0016S\n1\u0011I\\=SK\u001a\u0004BA\u0016B\u0018!&\u0019!\u0011G,\u0003\u00155c%+Z1eC\ndW\rE\u0002\u007f\u0005kI1Aa\u000ej\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\u0011\u0019#\u0001\u0003sK\u0006$WC\u0001B !\u00111&\u0011\t)\n\u0007\t\rsK\u0001\u0005N\u0019J+\u0017\rZ3sQ\rA\u0012o^\u0001\u0005Y>\fG\rF\u0002Q\u0005\u0017BaA!\u0014\u001a\u0001\u0004\u0019\u0017\u0001\u00029bi\"D3!G9x\u0005i9\u0015-^:tS\u0006tW*\u001b=ukJ,Wj\u001c3fY^\u0013\u0018\u000e^3s'\rQ\"1B\u0001\tS:\u001cH/\u00198dKR!!\u0011\fB/!\r\u0011YFG\u0007\u0002-!1!Q\u000b\u000fA\u0002A\u0013A\u0001R1uCN9QDa\n\u0003d\tM\u0002c\u0001@\u0003f%\u0019!qM5\u0003\u000fA\u0013x\u000eZ;di\u0006\u0019Q.^:\u0016\u0005\t5\u0004\u0003\u0002@\u0000\u0005_\u0002BA!\u001d\u0003z5\u0011!1\u000f\u0006\u0005\u0003c\u0014)HC\u0002\u0003x\u0011\u000bQ!\u001c7mS\nLA!!>\u0003t\u0005!Q.^:!\u0003\u0019\u0019\u0018nZ7bgV\u0011!\u0011\u0011\t\u0005}~\u0014\u0019\t\u0005\u0003\u0003r\t\u0015\u0015\u0002\u0002BD\u0005g\u0012a!T1ue&D\u0018aB:jO6\f7\u000f\t\u000b\t\u0005\u001b\u0013\tJa%\u0003\u0016B\u0019!qR\u000f\u000e\u0003iAQa\u001f\u0013A\u0002uDqA!\u001b%\u0001\u0004\u0011i\u0007C\u0004\u0003~\u0011\u0002\rA!!\u0015\u0011\t5%\u0011\u0014BN\u0005;Cqa_\u0013\u0011\u0002\u0003\u0007Q\u0010C\u0005\u0003j\u0015\u0002\n\u00111\u0001\u0003n!I!QP\u0013\u0011\u0002\u0003\u0007!\u0011Q\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\u0019KK\u0002~\u0005K[#Aa*\u0011\t\t%&\u0011W\u0007\u0003\u0005WSAA!,\u00030\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003i&LAAa-\u0003,\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u0018\u0016\u0005\u0005[\u0012)+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t}&\u0006\u0002BA\u0005K\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001Bc!\u0011\u00119M!5\u000e\u0005\t%'\u0002\u0002Bf\u0005\u001b\fA\u0001\\1oO*\u0011!qZ\u0001\u0005U\u00064\u0018-C\u0002o\u0005\u0013\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002F\ne\u0007\"\u0003BnW\u0005\u0005\t\u0019AA \u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\u001d\t\u0007\u0005G\u0014I/!2\u000e\u0005\t\u0015(b\u0001BtS\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t-(Q\u001d\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003r\n]\bc\u0001@\u0003t&\u0019!Q_5\u0003\u000f\t{w\u000e\\3b]\"I!1\\\u0017\u0002\u0002\u0003\u0007\u0011QY\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011q\b\u000b\u0003\u0005\u000b\fa!Z9vC2\u001cH\u0003\u0002By\u0007\u0007A\u0011Ba71\u0003\u0003\u0005\r!!2\u0002\t\u0011\u000bG/\u0019\t\u0004\u0005\u001f\u00134#\u0002\u001a\u0004\f\tM\u0002cCB\u0007\u0007'i(Q\u000eBA\u0005\u001bk!aa\u0004\u000b\u0007\rE\u0011.A\u0004sk:$\u0018.\\3\n\t\rU1q\u0002\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDCAB\u0004\u0003\u0015\t\u0007\u000f\u001d7z)!\u0011ii!\b\u0004 \r\u0005\u0002\"B>6\u0001\u0004i\bb\u0002B5k\u0001\u0007!Q\u000e\u0005\b\u0005{*\u0004\u0019\u0001BA\u0003\u001d)h.\u00199qYf$Baa\n\u00044A)ap!\u000b\u0004.%\u001911F5\u0003\r=\u0003H/[8o!!q8qF?\u0003n\t\u0005\u0015bAB\u0019S\n1A+\u001e9mKNB\u0011b!\u000e7\u0003\u0003\u0005\rA!$\u0002\u0007a$\u0003'\u0001\u0005tCZ,\u0017*\u001c9m)\u0011\u0019Yd!\u0011\u0011\u0007y\u001ci$C\u0002\u0004@%\u0014A!\u00168ji\"1!QJ\u001cA\u0002\r\u0014!dR1vgNL\u0017M\\'jqR,(/Z'pI\u0016d'+Z1eKJ\u001c2\u0001\u000fB )\t\u0019I\u0005E\u0002\u0003\\a\n\u0011b\u00197bgNt\u0015-\\3\u0002\u0015\rd\u0017m]:OC6,\u0007\u0005F\u0002Q\u0007#BaA!\u0014=\u0001\u0004\u0019\u0017\u0001F2p[B,H/\u001a)s_\n\f'-\u001b7ji&,7\u000fF\u0004~\u0007/\u001aIf!\u0018\t\u000f\u0005%X\b1\u0001\u0002l\"911L\u001fA\u0002\u0005M\u0011!\u00023jgR\u001c\b\"B>>\u0001\u0004i\u0018a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"aa\u0019\u0011\t\t\u001d7QM\u0005\u0005\u0007O\u0012IM\u0001\u0004PE*,7\r\u001e\u0015\u0004-E<\bfA\u000bro\u0002")
public class GaussianMixtureModel
extends Model<GaussianMixtureModel>
implements GaussianMixtureParams,
MLWritable,
HasTrainingSummary<GaussianMixtureSummary> {
    private int numFeatures;
    private final String uid;
    private final double[] weights;
    private final MultivariateGaussian[] gaussians;
    private Option<GaussianMixtureSummary> trainingSummary;
    private final IntParam k;
    private final IntParam aggregationDepth;
    private final DoubleParam tol;
    private final Param<String> probabilityCol;
    private final Param<String> weightCol;
    private final Param<String> predictionCol;
    private final LongParam seed;
    private final Param<String> featuresCol;
    private final IntParam maxIter;
    private volatile boolean bitmap$0;

    public static GaussianMixtureModel load(String string) {
        return GaussianMixtureModel$.MODULE$.load(string);
    }

    public static MLReader<GaussianMixtureModel> read() {
        return GaussianMixtureModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<GaussianMixtureSummary> setSummary(Option<GaussianMixtureSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getK() {
        return GaussianMixtureParams.getK$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return GaussianMixtureParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final String getProbabilityCol() {
        return HasProbabilityCol.getProbabilityCol$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final Option<GaussianMixtureSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<GaussianMixtureSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final void org$apache$spark$ml$clustering$GaussianMixtureParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final Param<String> probabilityCol() {
        return this.probabilityCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasProbabilityCol$_setter_$probabilityCol_$eq(Param<String> x$1) {
        this.probabilityCol = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public double[] weights() {
        return this.weights;
    }

    public MultivariateGaussian[] gaussians() {
        return this.gaussians;
    }

    private int numFeatures$lzycompute() {
        GaussianMixtureModel gaussianMixtureModel = this;
        synchronized (gaussianMixtureModel) {
            if (!this.bitmap$0) {
                this.numFeatures = ((MultivariateGaussian)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.gaussians())).head()).mean().size();
                this.bitmap$0 = true;
            }
        }
        return this.numFeatures;
    }

    public int numFeatures() {
        if (!this.bitmap$0) {
            return this.numFeatures$lzycompute();
        }
        return this.numFeatures;
    }

    public GaussianMixtureModel setFeaturesCol(String value) {
        return (GaussianMixtureModel)this.set(this.featuresCol(), value);
    }

    public GaussianMixtureModel setPredictionCol(String value) {
        return (GaussianMixtureModel)this.set(this.predictionCol(), value);
    }

    public GaussianMixtureModel setProbabilityCol(String value) {
        return (GaussianMixtureModel)this.set(this.probabilityCol(), value);
    }

    @Override
    public GaussianMixtureModel copy(ParamMap extra) {
        GaussianMixtureModel copied = this.copyValues(new GaussianMixtureModel(this.uid(), this.weights(), this.gaussians()), extra);
        return (GaussianMixtureModel)((Model)((Object)copied.setSummary(this.trainingSummary()))).setParent(this.parent());
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset outputData;
        block4: {
            StructType outputSchema = this.transformSchema(dataset.schema(), true);
            Column vectorCol = DatasetUtils$.MODULE$.columnToVector(dataset, this.$(this.featuresCol()));
            outputData = dataset;
            int numColsOutput = 0;
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.probabilityCol()))).nonEmpty()) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
                public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$1(GaussianMixtureModel $outer) {
                    }
                }
                public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator2$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator2$1(GaussianMixtureModel $outer) {
                    }
                }
                UserDefinedFunction probUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)vector -> this.predictProbability((org.apache.spark.ml.linalg.Vector)vector), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator2$1(null)));
                outputData = outputData.withColumn(this.$(this.probabilityCol()), probUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{vectorCol})), outputSchema.apply(this.$(this.probabilityCol())).metadata());
                ++numColsOutput;
            }
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
                if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.probabilityCol()))).nonEmpty()) {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator3$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator3$1(GaussianMixtureModel $outer) {
                        }
                    }
                    UserDefinedFunction predUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)vector -> BoxesRunTime.boxToInteger((int)vector.argmax()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator3$1(null)));
                    outputData = outputData.withColumn(this.$(this.predictionCol()), predUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.probabilityCol()))})), outputSchema.apply(this.$(this.predictionCol())).metadata());
                } else {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator4$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator4$1(GaussianMixtureModel $outer) {
                        }
                    }
                    UserDefinedFunction predUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)vector -> BoxesRunTime.boxToInteger((int)this.predict(vector)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator4$1(null)));
                    outputData = outputData.withColumn(this.$(this.predictionCol()), predUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{vectorCol})), outputSchema.apply(this.$(this.predictionCol())).metadata());
                }
                ++numColsOutput;
            }
            if (numColsOutput != false) break block4;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(83).append(this.uid()).append(": GaussianMixtureModel.transform() does nothing").append(" because no output columns were set.").toString());
        }
        return outputData.toDF();
    }

    @Override
    public StructType transformSchema(StructType schema) {
        StructType outputSchema;
        block1: {
            outputSchema = this.validateAndTransformSchema(schema);
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
                outputSchema = SchemaUtils$.MODULE$.updateNumValues(outputSchema, this.$(this.predictionCol()), this.weights().length);
            }
            if (!new StringOps(Predef$.MODULE$.augmentString(this.$(this.probabilityCol()))).nonEmpty()) break block1;
            outputSchema = SchemaUtils$.MODULE$.updateAttributeGroupSize(outputSchema, this.$(this.probabilityCol()), this.weights().length);
        }
        return outputSchema;
    }

    public int predict(org.apache.spark.ml.linalg.Vector features) {
        org.apache.spark.ml.linalg.Vector r = this.predictProbability(features);
        return r.argmax();
    }

    public org.apache.spark.ml.linalg.Vector predictProbability(org.apache.spark.ml.linalg.Vector features) {
        double[] probs = GaussianMixtureModel$.MODULE$.computeProbabilities(features, this.gaussians(), this.weights());
        return org.apache.spark.ml.linalg.Vectors$.MODULE$.dense(probs);
    }

    public Dataset<Row> gaussiansDF() {
        Tuple2[] modelGaussians = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.gaussians())).map((Function1 & Serializable & scala.Serializable)gaussian -> new Tuple2((Object)Vectors$.MODULE$.fromML(gaussian.mean()), (Object)Matrices$.MODULE$.fromML(gaussian.cov())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.mllib.linalg.Matrix").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$2(GaussianMixtureModel $outer) {
            }
        }
        return SparkSession$.MODULE$.builder().getOrCreate().createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])modelGaussians), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$2(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "cov"}));
    }

    @Override
    public MLWriter write() {
        return new GaussianMixtureModelWriter(this);
    }

    @Override
    public String toString() {
        return new StringBuilder(44).append("GaussianMixtureModel: uid=").append(this.uid()).append(", k=").append(this.weights().length).append(", numFeatures=").append(this.numFeatures()).toString();
    }

    @Override
    public GaussianMixtureSummary summary() {
        return (GaussianMixtureSummary)HasTrainingSummary.summary$(this);
    }

    public GaussianMixtureModel(String uid, double[] weights, MultivariateGaussian[] gaussians) {
        this.uid = uid;
        this.weights = weights;
        this.gaussians = gaussians;
        HasMaxIter.$init$(this);
        HasFeaturesCol.$init$(this);
        HasSeed.$init$(this);
        HasPredictionCol.$init$(this);
        HasWeightCol.$init$(this);
        HasProbabilityCol.$init$(this);
        HasTol.$init$(this);
        HasAggregationDepth.$init$(this);
        GaussianMixtureParams.$init$(this);
        MLWritable.$init$(this);
        HasTrainingSummary.$init$(this);
    }

    private static class GaussianMixtureModelReader
    extends MLReader<GaussianMixtureModel> {
        private final String className = GaussianMixtureModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public GaussianMixtureModel load(String path) {
            Matrix[] sigmas;
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            String dataPath = new Path(path, "data").toString();
            Row row = (Row)this.sparkSession().read().parquet(dataPath).select("weights", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mus", "sigmas"})).head();
            double[] weights = (double[])row.getSeq(0).toArray(ClassTag$.MODULE$.Double());
            Vector[] mus = (Vector[])row.getSeq(1).toArray(ClassTag$.MODULE$.apply(Vector.class));
            Predef$.MODULE$.require(mus.length == (sigmas = (Matrix[])row.getSeq(2).toArray(ClassTag$.MODULE$.apply(Matrix.class))).length, (Function0 & Serializable & scala.Serializable)() -> "Length of Mu and Sigma array must match");
            Predef$.MODULE$.require(mus.length == weights.length, (Function0 & Serializable & scala.Serializable)() -> "Length of weight and Gaussian array must match");
            MultivariateGaussian[] gaussians = (MultivariateGaussian[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mus)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sigmas), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Vector mu = (Vector)tuple2._1();
                    Matrix sigma = (Matrix)tuple2._2();
                    return new MultivariateGaussian(mu.asML(), sigma.asML());
                }
                throw new MatchError((Object)tuple2);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MultivariateGaussian.class)));
            GaussianMixtureModel model = new GaussianMixtureModel(metadata.uid(), weights, gaussians);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class GaussianMixtureModelWriter
    extends MLWriter {
        private volatile GaussianMixtureModel$GaussianMixtureModelWriter$Data$ Data$module;
        private final GaussianMixtureModel instance;

        private GaussianMixtureModel$GaussianMixtureModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            double[] weights = this.instance.weights();
            MultivariateGaussian[] gaussians = this.instance.gaussians();
            Vector[] mus = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gaussians)).map((Function1 & Serializable & scala.Serializable)g -> Vectors$.MODULE$.fromML(g.mean()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            Matrix[] sigmas = (Matrix[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gaussians)).map((Function1 & Serializable & scala.Serializable)c -> Matrices$.MODULE$.fromML(c.cov()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Matrix.class)));
            Data data = new Data(this, weights, mus, sigmas);
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelWriter$$typecreator1$3
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.clustering.GaussianMixtureModel.GaussianMixtureModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.clustering.GaussianMixtureModel.GaussianMixtureModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelWriter$$typecreator1$3(GaussianMixtureModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)new .colon.colon((Object)data, (List)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelWriter$$typecreator1$3(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            GaussianMixtureModelWriter gaussianMixtureModelWriter = this;
            synchronized (gaussianMixtureModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new GaussianMixtureModel$GaussianMixtureModelWriter$Data$(this);
                }
            }
        }

        public GaussianMixtureModelWriter(GaussianMixtureModel instance) {
            this.instance = instance;
        }

        private class Data
        implements Product,
        scala.Serializable {
            private final double[] weights;
            private final Vector[] mus;
            private final Matrix[] sigmas;
            public final /* synthetic */ GaussianMixtureModelWriter $outer;

            public double[] weights() {
                return this.weights;
            }

            public Vector[] mus() {
                return this.mus;
            }

            public Matrix[] sigmas() {
                return this.sigmas;
            }

            public Data copy(double[] weights, Vector[] mus, Matrix[] sigmas) {
                return new Data(this.org$apache$spark$ml$clustering$GaussianMixtureModel$GaussianMixtureModelWriter$Data$$$outer(), weights, mus, sigmas);
            }

            public double[] copy$default$1() {
                return this.weights();
            }

            public Vector[] copy$default$2() {
                return this.mus();
            }

            public Matrix[] copy$default$3() {
                return this.sigmas();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                int n = x$1;
                switch (n) {
                    case 0: {
                        return this.weights();
                    }
                    case 1: {
                        return this.mus();
                    }
                    case 2: {
                        return this.sigmas();
                    }
                }
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$clustering$GaussianMixtureModel$GaussianMixtureModelWriter$Data$$$outer() != this.org$apache$spark$ml$clustering$GaussianMixtureModel$GaussianMixtureModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.weights() != data.weights()) return false;
                if (this.mus() != data.mus()) return false;
                if (this.sigmas() != data.sigmas()) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ GaussianMixtureModelWriter org$apache$spark$ml$clustering$GaussianMixtureModel$GaussianMixtureModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(GaussianMixtureModelWriter $outer, double[] weights, Vector[] mus, Matrix[] sigmas) {
                this.weights = weights;
                this.mus = mus;
                this.sigmas = sigmas;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

