/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import jline.console.ConsoleReader;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cli.CliDriver;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.cli.OptionsProcessor;
import org.apache.hadoop.hive.common.HiveInterruptUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.util.SQLKeywordUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.client.HiveClientImpl$;
import org.apache.spark.sql.hive.security.HiveDelegationTokenProvider;
import org.apache.spark.sql.hive.thriftserver.ReflectionUtils$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver;
import org.apache.spark.sql.hive.thriftserver.SparkSQLEnv$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.SessionResourceLoader;
import org.apache.spark.sql.internal.SharedState$;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.SparkExitCode$;
import org.apache.thrift.transport.TSocket;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

public final class SparkSQLCLIDriver$
implements Logging {
    public static SparkSQLCLIDriver$ MODULE$;
    private final String prompt;
    private final String continuedPrompt;
    private TSocket transport;
    private int exitCode;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkSQLCLIDriver$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String prompt() {
        return this.prompt;
    }

    private String continuedPrompt() {
        return this.continuedPrompt;
    }

    private TSocket transport() {
        return this.transport;
    }

    private void transport_$eq(TSocket x$1) {
        this.transport = x$1;
    }

    private final String SPARK_HADOOP_PROP_PREFIX() {
        return "spark.hadoop.";
    }

    private int exitCode() {
        return this.exitCode;
    }

    private void exitCode_$eq(int x$1) {
        this.exitCode = x$1;
    }

    public void installSignalHandler() {
        HiveInterruptUtils.add(() -> {
            if (SparkSQLEnv$.MODULE$.sparkContext() != null) {
                SparkSQLEnv$.MODULE$.sparkContext().cancelAllJobs();
                return;
            }
            if (MODULE$.transport() != null) {
                MODULE$.transport().getSocket().close();
                return;
            }
        });
    }

    public void exit(int code) {
        this.exitCode_$eq(code);
        System.exit(this.exitCode());
    }

    public void main(String[] args) {
        OptionsProcessor oproc = new OptionsProcessor();
        if (!oproc.process_stage1(args)) {
            System.exit(SparkExitCode$.MODULE$.EXIT_FAILURE());
        }
        SparkConf sparkConf = new SparkConf(true);
        Configuration hadoopConf = SparkHadoopUtil$.MODULE$.get().newConfiguration(sparkConf);
        Map extraConfigs = HiveUtils$.MODULE$.formatTimeVarsForHiveClient(hadoopConf);
        HiveConf cliConf = HiveClientImpl$.MODULE$.newHiveConf(sparkConf, (Iterable)hadoopConf, extraConfigs, HiveClientImpl$.MODULE$.newHiveConf$default$4());
        CliSessionState sessionState = new CliSessionState(cliConf);
        sessionState.in = System.in;
        try {
            sessionState.out = new PrintStream((OutputStream)System.out, true, StandardCharsets.UTF_8.name());
            sessionState.info = new PrintStream((OutputStream)System.err, true, StandardCharsets.UTF_8.name());
            sessionState.err = new PrintStream((OutputStream)System.err, true, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$closeHiveSessionStateIfStarted((SessionState)sessionState);
            this.exit(SparkExitCode$.MODULE$.ERROR_PATH_NOT_FOUND());
        }
        if (!oproc.process_stage2(sessionState)) {
            this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$closeHiveSessionStateIfStarted((SessionState)sessionState);
            this.exit(SparkExitCode$.MODULE$.ERROR_MISUSE_SHELL_BUILTIN());
        }
        HiveConf conf = sessionState.getConf();
        conf.setClassLoader(Thread.currentThread().getContextClassLoader());
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(sessionState.cmdProperties.entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)item -> {
            String key = item.getKey().toString();
            String value = item.getValue().toString();
            String string = key;
            String string2 = "javax.jdo.option.ConnectionURL";
            if (string == null ? string2 != null : !string.equals(string2)) {
                conf.set(key, value);
                return sessionState.getOverriddenConfigurations().put(key, value);
            }
            return BoxedUnit.UNIT;
        });
        HiveDelegationTokenProvider tokenProvider = new HiveDelegationTokenProvider();
        if (tokenProvider.delegationTokensRequired(sparkConf, hadoopConf)) {
            Credentials credentials = new Credentials();
            tokenProvider.obtainDelegationTokens(hadoopConf, sparkConf, credentials);
            UserGroupInformation.getCurrentUser().addCredentials(credentials);
        }
        String warehousePath = SharedState$.MODULE$.resolveWarehousePath(sparkConf, (Configuration)conf, SharedState$.MODULE$.resolveWarehousePath$default$3());
        String qualified = SharedState$.MODULE$.qualifyWarehousePath((Configuration)conf, warehousePath);
        SharedState$.MODULE$.setWarehousePathConf(sparkConf, (Configuration)conf, qualified);
        SessionState.setCurrentSessionState((SessionState)sessionState);
        ShutdownHookManager$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MODULE$.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$closeHiveSessionStateIfStarted((SessionState)sessionState);
            SparkSQLEnv$.MODULE$.stop(MODULE$.exitCode());
        });
        if (this.isRemoteMode(sessionState)) {
            throw QueryExecutionErrors$.MODULE$.remoteOperationsUnsupportedError();
        }
        Set hiveConfFromCmd = (Set)JavaConverters$.MODULE$.asScalaSetConverter(sessionState.getOverriddenConfigurations().entrySet()).asScala();
        Set newHiveConf = (Set)hiveConfFromCmd.map((Function1 & Serializable & scala.Serializable)kv -> {
            String k = (String)kv.getKey();
            String v = (String)package$.MODULE$.props().getOrElseUpdate((Object)new StringBuilder(13).append("spark.hadoop.").append(k).toString(), (Function0 & Serializable & scala.Serializable)() -> (String)kv.getValue());
            return new Tuple2((Object)k, (Object)v);
        }, Set$.MODULE$.canBuildFrom());
        SparkSQLCLIDriver cli = new SparkSQLCLIDriver();
        cli.setHiveVariables(oproc.getHiveVariables());
        String auxJars = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEAUXJARS);
        if (StringUtils.isNotBlank((CharSequence)auxJars)) {
            SessionResourceLoader resourceLoader = SparkSQLEnv$.MODULE$.sqlContext().sessionState().resourceLoader();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])StringUtils.split((String)auxJars, (String)","))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                resourceLoader.addJar(x$1);
                return BoxedUnit.UNIT;
            });
        }
        sessionState.getConf().setClassLoader((ClassLoader)SparkSQLEnv$.MODULE$.sqlContext().sharedState().jarClassLoader());
        sessionState.in = System.in;
        try {
            sessionState.out = new PrintStream((OutputStream)System.out, true, StandardCharsets.UTF_8.name());
            sessionState.info = new PrintStream((OutputStream)System.err, true, StandardCharsets.UTF_8.name());
            sessionState.err = new PrintStream((OutputStream)System.err, true, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            this.exit(SparkExitCode$.MODULE$.ERROR_PATH_NOT_FOUND());
        }
        newHiveConf.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SparkSQLCLIDriver$.$anonfun$main$6(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SparkSQLCLIDriver$.$anonfun$main$7(x$2))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            SparkSQLCLIDriver$.$anonfun$main$8(x$3);
            return BoxedUnit.UNIT;
        });
        Object object = sessionState.database != null ? SparkSQLEnv$.MODULE$.sqlContext().sql(new StringBuilder(4).append("USE ").append(sessionState.database).toString()) : BoxedUnit.UNIT;
        cli.processInitFiles(sessionState);
        cli.printMasterAndAppId();
        if (sessionState.execString != null) {
            this.exit(cli.processLine(sessionState.execString));
        }
        try {
            if (sessionState.fileName != null) {
                this.exit(cli.processFile(sessionState.fileName));
            }
        }
        catch (FileNotFoundException e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Could not open input file for reading. (").append(e.getMessage()).append(")").toString());
            this.exit(SparkExitCode$.MODULE$.ERROR_PATH_NOT_FOUND());
        }
        ConsoleReader reader = new ConsoleReader();
        reader.setBellEnabled(false);
        reader.setExpandEvents(false);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getCommandCompleter())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)reader.addCompleter(x$1)));
        String historyDirectory = System.getProperty("user.home");
        try {
            if (new File(historyDirectory).exists()) {
                String historyFile = new StringBuilder(12).append(historyDirectory).append(File.separator).append(".hivehistory").toString();
                reader.setHistory((History)new FileHistory(new File(historyFile)));
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append("WARNING: Directory for Hive history file: ").append(historyDirectory).append(" does not exist.   History will not be available during this session.").toString());
            }
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "WARNING: Encountered an error while trying to initialize Hive's history file.  History will not be available during this session.");
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage());
        }
        ShutdownHookManager$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            History history = reader.getHistory();
            if (history instanceof FileHistory) {
                BoxedUnit boxedUnit;
                FileHistory fileHistory = (FileHistory)history;
                try {
                    fileHistory.flush();
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (IOException e) {
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("WARNING: Failed to write command history file: ").append(e.getMessage()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
        });
        this.transport_$eq(null);
        int ret = 0;
        String prefix = "";
        String currentPrompt = this.promptWithCurrentDB$1(conf, sessionState);
        String line = reader.readLine(new StringBuilder(2).append(currentPrompt).append("> ").toString());
        while (line != null) {
            if (!line.startsWith("--")) {
                if (new StringOps(Predef$.MODULE$.augmentString(prefix)).nonEmpty()) {
                    prefix = new StringBuilder(0).append(prefix).append('\n').toString();
                }
                if (line.trim().endsWith(";") && !line.trim().endsWith("\\;")) {
                    line = new StringBuilder(0).append(prefix).append(line).toString();
                    ret = cli.processLine(line, true);
                    prefix = "";
                    currentPrompt = this.promptWithCurrentDB$1(conf, sessionState);
                } else {
                    prefix = new StringBuilder(0).append(prefix).append(line).toString();
                    currentPrompt = this.continuedPromptWithDBSpaces$1(conf, sessionState);
                }
            }
            line = reader.readLine(new StringBuilder(2).append(currentPrompt).append("> ").toString());
        }
        this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$closeHiveSessionStateIfStarted((SessionState)sessionState);
        this.exit(ret);
    }

    public boolean isRemoteMode(CliSessionState state) {
        return state.isHiveServerQuery();
    }

    public void printUsage() {
        OptionsProcessor processor = new OptionsProcessor();
        ReflectionUtils$.MODULE$.invoke(OptionsProcessor.class, processor, "printUsage", (Seq<Tuple2<Class<?>, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    public void org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$closeHiveSessionStateIfStarted(SessionState state) {
        if (BoxesRunTime.unboxToBoolean(ReflectionUtils$.MODULE$.getSuperField(state, "isStarted"))) {
            state.close();
            return;
        }
    }

    private Completer[] getCommandCompleter() {
        ArrayList candidateStrings = new ArrayList();
        ((IterableLike)FunctionRegistry$.MODULE$.builtin().listFunction().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.funcName(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)SparkSQLCLIDriver$.$anonfun$getCommandCompleter$2(candidateStrings, s)));
        SQLKeywordUtils$.MODULE$.keywords().foreach((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)SparkSQLCLIDriver$.$anonfun$getCommandCompleter$3(candidateStrings, s)));
        StringsCompleter strCompleter = new StringsCompleter(candidateStrings);
        ArgumentCompleter.AbstractArgumentDelimiter delim = new ArgumentCompleter.AbstractArgumentDelimiter(){

            public boolean isDelimiterChar(CharSequence buffer, int pos) {
                char c = buffer.charAt(pos);
                return Character.isWhitespace(c) || c == '(' || c == ')' || c == '[' || c == ']';
            }
        };
        ArgumentCompleter argCompleter = new ArgumentCompleter((ArgumentCompleter.ArgumentDelimiter)delim, new Completer[]{strCompleter});
        argCompleter.setStrict(false);
        Completer customCompleter = new Completer(argCompleter){
            private final ArgumentCompleter argCompleter$1;

            public int complete(String buffer, int offset, List<CharSequence> completions) {
                List<CharSequence> comp = completions;
                int ret = this.argCompleter$1.complete(buffer, offset, completions);
                Object object = completions.size() == 1 && ((String)comp.get(0)).endsWith("( ") ? comp.set(0, ((String)comp.get(0)).trim()) : BoxedUnit.UNIT;
                return ret;
            }
            {
                this.argCompleter$1 = argCompleter$1;
            }
        };
        StringsCompleter confCompleter = new StringsCompleter(){

            public int complete(String buffer, int cursor, List<CharSequence> clist) {
                return super.complete(buffer, cursor, clist);
            }
        };
        StringsCompleter setCompleter = new StringsCompleter(){

            public int complete(String buffer, int cursor, List<CharSequence> clist) {
                if (buffer != null && buffer.equalsIgnoreCase("set")) {
                    return super.complete(buffer, cursor, clist);
                }
                return -1;
            }
        };
        ArgumentCompleter propCompleter = new ArgumentCompleter(setCompleter, confCompleter){

            public int complete(String buffer, int offset, List<CharSequence> completions) {
                int ret = super.complete(buffer, offset, completions);
                Object object = completions.size() == 1 ? completions.set(0, ((String)completions.get(0)).trim()) : BoxedUnit.UNIT;
                return ret;
            }
        };
        return (Completer[])((Object[])new Completer[]{propCompleter, customCompleter});
    }

    public static final /* synthetic */ boolean $anonfun$main$6(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$main$7(Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            String k;
            String string = k = (String)tuple2._1();
            String string2 = "hive.metastore.warehouse.dir";
            return string == null ? string2 != null : !string.equals(string2);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$main$8(Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            SparkSQLEnv$.MODULE$.sqlContext().setConf(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Object currentDB$1(HiveConf conf$1, CliSessionState sessionState$1) {
        if (!BoxesRunTime.unboxToBoolean((Object)SparkSQLEnv$.MODULE$.sqlContext().conf().getConf(SQLConf$.MODULE$.LEGACY_EMPTY_CURRENT_DB_IN_CLI()))) {
            return new StringBuilder(3).append(" (").append(SparkSQLEnv$.MODULE$.sqlContext().sparkSession().catalog().currentDatabase()).append(")").toString();
        }
        return ReflectionUtils$.MODULE$.invokeStatic(CliDriver.class, "getFormattedDb", (Seq<Tuple2<Class<?>, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(HiveConf.class), (Object)conf$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(CliSessionState.class), (Object)sessionState$1)}));
    }

    private final String promptWithCurrentDB$1(HiveConf conf$1, CliSessionState sessionState$1) {
        return new StringBuilder(0).append(this.prompt()).append(SparkSQLCLIDriver$.currentDB$1(conf$1, sessionState$1)).toString();
    }

    private final String continuedPromptWithDBSpaces$1(HiveConf conf$1, CliSessionState sessionState$1) {
        return new StringBuilder(0).append(this.continuedPrompt()).append(ReflectionUtils$.MODULE$.invokeStatic(CliDriver.class, "spacesForString", (Seq<Tuple2<Class<?>, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(String.class), SparkSQLCLIDriver$.currentDB$1(conf$1, sessionState$1))}))).toString();
    }

    public static final /* synthetic */ boolean $anonfun$getCommandCompleter$2(ArrayList candidateStrings$1, String s) {
        if (s.matches("[a-z_]+")) {
            return candidateStrings$1.add(new StringBuilder(1).append(s).append("(").toString());
        }
        return candidateStrings$1.add(s);
    }

    public static final /* synthetic */ boolean $anonfun$getCommandCompleter$3(ArrayList candidateStrings$1, String s) {
        candidateStrings$1.add(s);
        return candidateStrings$1.add(s.toLowerCase(Locale.ROOT));
    }

    private SparkSQLCLIDriver$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.prompt = "spark-sql";
        this.continuedPrompt = (String)new StringOps(Predef$.MODULE$.augmentString("")).padTo(this.prompt().length(), (Object)BoxesRunTime.boxToCharacter((char)' '), Predef$.MODULE$.StringCanBuildFrom());
        this.exitCode = 0;
        this.initializeLogIfNecessary(true);
        this.installSignalHandler();
    }
}

