/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.apache.jackrabbit.commons.iterator.NodeTypeIteratorAdapter;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.EffectiveNodeTypeImpl;
import org.apache.jackrabbit.oak.plugins.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.oak.plugins.nodetype.RootNodeDefinition;
import org.apache.jackrabbit.oak.spi.nodetype.DefinitionProvider;
import org.apache.jackrabbit.oak.spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.oak.spi.nodetype.EffectiveNodeTypeProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReadOnlyNodeTypeManager
implements NodeTypeManager,
EffectiveNodeTypeProvider,
DefinitionProvider {
    @NotNull
    protected final String getOakName(String jcrName) throws RepositoryException {
        return this.getNamePathMapper().getOakName(jcrName);
    }

    @NotNull
    protected abstract Tree getTypes();

    @Nullable
    protected ValueFactory getValueFactory() {
        return null;
    }

    @NotNull
    protected NamePathMapper getNamePathMapper() {
        return NamePathMapper.DEFAULT;
    }

    @NotNull
    public static ReadOnlyNodeTypeManager getInstance(final Root root, final NamePathMapper namePathMapper) {
        return new ReadOnlyNodeTypeManager(){

            @Override
            @NotNull
            protected Tree getTypes() {
                return root.getTree("/jcr:system/jcr:nodeTypes");
            }

            @Override
            @NotNull
            protected NamePathMapper getNamePathMapper() {
                return namePathMapper;
            }
        };
    }

    public boolean hasNodeType(String name) throws RepositoryException {
        return this.getTypes().hasChild(this.getOakName(name));
    }

    public NodeType getNodeType(String name) throws RepositoryException {
        return this.internalGetNodeType(this.getOakName(name));
    }

    public NodeTypeIterator getAllNodeTypes() throws RepositoryException {
        ArrayList<NodeType> list = new ArrayList<NodeType>();
        Tree types = this.getTypes();
        NamePathMapper mapper = this.getNamePathMapper();
        for (Tree type : types.getChildren()) {
            list.add(new NodeTypeImpl(type, mapper));
        }
        return new NodeTypeIteratorAdapter(list);
    }

    public NodeTypeIterator getPrimaryNodeTypes() throws RepositoryException {
        ArrayList<NodeType> list = new ArrayList<NodeType>();
        NodeTypeIterator iterator = this.getAllNodeTypes();
        while (iterator.hasNext()) {
            NodeType type = iterator.nextNodeType();
            if (type.isMixin()) continue;
            list.add(type);
        }
        return new NodeTypeIteratorAdapter(list);
    }

    public NodeTypeIterator getMixinNodeTypes() throws RepositoryException {
        ArrayList<NodeType> list = new ArrayList<NodeType>();
        NodeTypeIterator iterator = this.getAllNodeTypes();
        while (iterator.hasNext()) {
            NodeType type = iterator.nextNodeType();
            if (!type.isMixin()) continue;
            list.add(type);
        }
        return new NodeTypeIteratorAdapter(list);
    }

    public NodeTypeTemplate createNodeTypeTemplate() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeTypeTemplate createNodeTypeTemplate(NodeTypeDefinition ntd) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeDefinitionTemplate createNodeDefinitionTemplate() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public PropertyDefinitionTemplate createPropertyDefinitionTemplate() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeType registerNodeType(NodeTypeDefinition ntd, boolean allowUpdate) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeTypeIterator registerNodeTypes(NodeTypeDefinition[] ntds, boolean allowUpdate) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void unregisterNodeType(String name) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void unregisterNodeTypes(String[] names) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    @Override
    public boolean isNodeType(@NotNull Tree tree, @NotNull String oakNtName) {
        String name;
        if ("nt:base".equals(oakNtName)) {
            return true;
        }
        if ("mix:referenceable".equals(oakNtName) && !tree.hasProperty("jcr:uuid")) {
            return false;
        }
        if ("mix:versionable".equals(oakNtName) && !tree.hasProperty("jcr:isCheckedOut")) {
            return false;
        }
        Tree types = this.getTypes();
        PropertyState primary = tree.getProperty("jcr:primaryType");
        if (primary != null && primary.getType() == Type.NAME && ReadOnlyNodeTypeManager.isa(types, name = primary.getValue(Type.NAME), oakNtName)) {
            return true;
        }
        PropertyState mixins = tree.getProperty("jcr:mixinTypes");
        if (mixins != null && mixins.getType() == Type.NAMES) {
            for (String name2 : mixins.getValue(Type.NAMES)) {
                if (!ReadOnlyNodeTypeManager.isa(types, name2, oakNtName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isNodeType(@Nullable String primaryTypeName, @NotNull Supplier<Iterable<String>> mixinTypes, @NotNull String nodeTypeName) {
        if ("nt:base".equals(nodeTypeName)) {
            return true;
        }
        Tree types = this.getTypes();
        if (primaryTypeName != null && ReadOnlyNodeTypeManager.isa(types, primaryTypeName, nodeTypeName)) {
            return true;
        }
        for (String mixin : mixinTypes.get()) {
            if (!ReadOnlyNodeTypeManager.isa(types, mixin, nodeTypeName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isa(Tree types, String typeName, String superName) {
        if (typeName.equals(superName)) {
            return true;
        }
        Tree type = types.getChild(typeName);
        if (!type.exists()) {
            return false;
        }
        PropertyState supertypes = type.getProperty("rep:supertypes");
        return supertypes != null && IterableUtils.contains(supertypes.getValue(Type.NAMES), superName);
    }

    @Override
    public boolean isNodeType(@NotNull String typeName, @NotNull String superName) {
        return ReadOnlyNodeTypeManager.isa(this.getTypes(), typeName, superName);
    }

    @Override
    @NotNull
    public EffectiveNodeType getEffectiveNodeType(@NotNull Node node) throws RepositoryException {
        NodeTypeImpl primary = (NodeTypeImpl)node.getPrimaryNodeType();
        NodeType[] mixins = node.getMixinNodeTypes();
        NodeTypeImpl[] mixinImpls = new NodeTypeImpl[mixins.length];
        for (int i = 0; i < mixins.length; ++i) {
            mixinImpls[i] = (NodeTypeImpl)mixins[i];
        }
        return new EffectiveNodeTypeImpl(primary, mixinImpls, this);
    }

    @Override
    @NotNull
    public EffectiveNodeType getEffectiveNodeType(@NotNull Tree tree) throws RepositoryException {
        PropertyState jcrPrimaryType = tree.getProperty("jcr:primaryType");
        if (jcrPrimaryType == null) {
            throw new RepositoryException("Node at " + tree.getPath() + " has no primary type.");
        }
        String ntName = jcrPrimaryType.getValue(Type.STRING);
        NodeTypeImpl primaryType = this.internalGetNodeType(ntName);
        PropertyState jcrMixinType = tree.getProperty("jcr:mixinTypes");
        if (jcrMixinType == null) {
            return new EffectiveNodeTypeImpl(primaryType, this);
        }
        NodeTypeImpl[] mixinTypes = new NodeTypeImpl[jcrMixinType.count()];
        for (int i = 0; i < mixinTypes.length; ++i) {
            mixinTypes[i] = this.internalGetNodeType(jcrMixinType.getValue(Type.NAME, i));
        }
        return new EffectiveNodeTypeImpl(primaryType, mixinTypes, this);
    }

    @Override
    @NotNull
    public NodeDefinition getRootDefinition() throws RepositoryException {
        return new RootNodeDefinition(this);
    }

    @Override
    @NotNull
    public NodeDefinition getDefinition(@NotNull Tree parent, @NotNull String nodeName) throws RepositoryException {
        Objects.requireNonNull(parent);
        Objects.requireNonNull(nodeName);
        EffectiveNodeType effective = this.getEffectiveNodeType(parent);
        return effective.getNodeDefinition(nodeName, null);
    }

    @Override
    @NotNull
    public NodeDefinition getDefinition(@NotNull Tree parent, @NotNull Tree targetNode) throws RepositoryException {
        Objects.requireNonNull(parent);
        Objects.requireNonNull(targetNode);
        String name = PathUtils.dropIndexFromName(targetNode.getName());
        EffectiveNodeType eff = this.getEffectiveNodeType(parent);
        return eff.getNodeDefinition(name, this.getEffectiveNodeType(targetNode));
    }

    @Override
    @NotNull
    public PropertyDefinition getDefinition(@NotNull Tree parent, @NotNull PropertyState property, boolean exactTypeMatch) throws RepositoryException {
        Type<?> type = property.getType();
        EffectiveNodeType effective = this.getEffectiveNodeType(parent);
        return effective.getPropertyDefinition(property.getName(), type.isArray(), type.tag(), exactTypeMatch);
    }

    @NotNull
    NodeTypeImpl internalGetNodeType(@NotNull String oakName) throws NoSuchNodeTypeException {
        Tree types = this.getTypes();
        Tree type = types.getChild(oakName);
        if (type.exists()) {
            return new NodeTypeImpl(type, this.getNamePathMapper());
        }
        throw new NoSuchNodeTypeException(this.getNamePathMapper().getJcrName(oakName));
    }
}

