/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.cow;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.commons.collections.ListUtils;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.jetbrains.annotations.NotNull;

public class BranchNodeStore
implements NodeStore,
Observable {
    private static final long CHECKPOINT_LIFETIME = TimeUnit.HOURS.toMillis(24L);
    private final NodeStore nodeStore;
    private final MemoryNodeStore memoryNodeStore;
    private final Collection<String> inheritedCheckpoints;
    private final Map<String, String> checkpointMapping;

    public BranchNodeStore(NodeStore nodeStore) throws CommitFailedException {
        this.nodeStore = nodeStore;
        this.inheritedCheckpoints = ListUtils.toList(nodeStore.checkpoints());
        this.checkpointMapping = new ConcurrentHashMap<String, String>();
        String cp = nodeStore.checkpoint(CHECKPOINT_LIFETIME, Collections.singletonMap("type", "copy-on-write"));
        this.memoryNodeStore = new MemoryNodeStore(nodeStore.retrieve(cp));
    }

    public void dispose() {
        for (String cp : this.nodeStore.checkpoints()) {
            if (!"copy-on-write".equals(this.nodeStore.checkpointInfo(cp).get("type"))) continue;
            this.nodeStore.release(cp);
        }
    }

    @Override
    @NotNull
    public NodeState getRoot() {
        return this.memoryNodeStore.getRoot();
    }

    @Override
    @NotNull
    public synchronized NodeState merge(@NotNull NodeBuilder builder, @NotNull CommitHook commitHook, @NotNull CommitInfo info) throws CommitFailedException {
        return this.memoryNodeStore.merge(builder, commitHook, info);
    }

    @Override
    @NotNull
    public NodeState rebase(@NotNull NodeBuilder builder) {
        return this.memoryNodeStore.rebase(builder);
    }

    @Override
    public NodeState reset(@NotNull NodeBuilder builder) {
        return this.memoryNodeStore.reset(builder);
    }

    @Override
    @NotNull
    public Blob createBlob(InputStream inputStream) throws IOException {
        return this.memoryNodeStore.createBlob(inputStream);
    }

    @Override
    public Blob getBlob(@NotNull String reference) {
        return this.memoryNodeStore.getBlob(reference);
    }

    @Override
    @NotNull
    public String checkpoint(long lifetime, @NotNull Map<String, String> properties) {
        String checkpoint = this.memoryNodeStore.checkpoint(lifetime, properties);
        String uuid = UUID.randomUUID().toString();
        this.checkpointMapping.put(uuid, checkpoint);
        return uuid;
    }

    @Override
    @NotNull
    public String checkpoint(long lifetime) {
        return this.checkpoint(lifetime, Collections.emptyMap());
    }

    @Override
    @NotNull
    public Iterable<String> checkpoints() {
        ArrayList<String> result = new ArrayList<String>(this.inheritedCheckpoints);
        result.retainAll(ListUtils.toList(this.nodeStore.checkpoints()));
        this.checkpointMapping.entrySet().stream().filter(e -> this.memoryNodeStore.listCheckpoints().contains(e.getValue())).map(Map.Entry::getKey).forEach(result::add);
        return result;
    }

    @Override
    @NotNull
    public Map<String, String> checkpointInfo(@NotNull String checkpoint) {
        if (this.inheritedCheckpoints.contains(checkpoint)) {
            return this.nodeStore.checkpointInfo(checkpoint);
        }
        if (this.checkpointMapping.containsKey(checkpoint)) {
            return this.memoryNodeStore.checkpointInfo(this.checkpointMapping.get(checkpoint));
        }
        return Collections.emptyMap();
    }

    @Override
    public NodeState retrieve(@NotNull String checkpoint) {
        if (this.inheritedCheckpoints.contains(checkpoint)) {
            return this.nodeStore.retrieve(checkpoint);
        }
        if (this.checkpointMapping.containsKey(checkpoint)) {
            return this.memoryNodeStore.retrieve(this.checkpointMapping.get(checkpoint));
        }
        return null;
    }

    @Override
    public boolean release(@NotNull String checkpoint) {
        if (this.inheritedCheckpoints.contains(checkpoint)) {
            return this.nodeStore.release(checkpoint);
        }
        if (this.checkpointMapping.containsKey(checkpoint)) {
            return this.memoryNodeStore.release(this.checkpointMapping.remove(checkpoint));
        }
        return false;
    }

    @Override
    public Closeable addObserver(Observer observer) {
        return this.memoryNodeStore.addObserver(observer);
    }
}

