/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.json.JsopReader;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class JsonUtils {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static Map<String, Object> convertNodeStateToMap(NodeState nodeState, int maxDepth, boolean shouldSerializeHiddenNodesOrProperties) {
        return JsonUtils.convertNodeStateToMap(nodeState, maxDepth, -1, shouldSerializeHiddenNodesOrProperties);
    }

    private static Map<String, Object> convertNodeStateToMap(NodeState nodeState, int maxDepth, int currentDepth, boolean shouldSerializeHiddenNodesOrProperties) {
        if (maxDepth >= 0 && currentDepth >= maxDepth) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (PropertyState propertyState : nodeState.getProperties()) {
            String name = propertyState.getName();
            Type<?> type = propertyState.getType();
            if (!shouldSerializeHiddenNodesOrProperties && name.startsWith(":")) continue;
            if (propertyState.isArray()) {
                if (type == Type.STRINGS) {
                    result.put(name, propertyState.getValue(Type.STRINGS));
                    continue;
                }
                if (type == Type.LONGS) {
                    result.put(name, propertyState.getValue(Type.LONGS));
                    continue;
                }
                if (type == Type.DOUBLES) {
                    result.put(name, propertyState.getValue(Type.DOUBLES));
                    continue;
                }
                if (type == Type.BOOLEANS) {
                    result.put(name, propertyState.getValue(Type.BOOLEANS));
                    continue;
                }
                if (type == Type.DATES) {
                    result.put(name, propertyState.getValue(Type.DATES));
                    continue;
                }
                if (type == Type.DECIMALS) {
                    result.put(name, propertyState.getValue(Type.DECIMALS));
                    continue;
                }
                ArrayList<String> values = new ArrayList<String>();
                for (int i = 0; i < propertyState.count(); ++i) {
                    values.add(propertyState.getValue(Type.STRING, i));
                }
                result.put(name, values);
                continue;
            }
            if (type == Type.STRING) {
                result.put(name, propertyState.getValue(Type.STRING));
                continue;
            }
            if (type == Type.LONG) {
                result.put(name, propertyState.getValue(Type.LONG));
                continue;
            }
            if (type == Type.DOUBLE) {
                result.put(name, propertyState.getValue(Type.DOUBLE));
                continue;
            }
            if (type == Type.BOOLEAN) {
                result.put(name, propertyState.getValue(Type.BOOLEAN));
                continue;
            }
            if (type == Type.DATE) {
                result.put(name, propertyState.getValue(Type.DATE));
                continue;
            }
            if (type == Type.DECIMAL) {
                result.put(name, propertyState.getValue(Type.DECIMAL));
                continue;
            }
            result.put(name, propertyState.getValue(Type.STRING));
        }
        for (String string : nodeState.getChildNodeNames()) {
            NodeState childNode;
            Map<String, Object> childMap;
            if (!shouldSerializeHiddenNodesOrProperties && string.startsWith(":") || (childMap = JsonUtils.convertNodeStateToMap(childNode = nodeState.getChildNode(string), maxDepth, currentDepth + 1, shouldSerializeHiddenNodesOrProperties)) == null) continue;
            result.put(string, childMap);
        }
        return result;
    }

    public static String nodeStateToJson(NodeState nodeState, int maxDepth) throws JsonProcessingException {
        JsonNode jsonNode = JsonUtils.convertNodeStateToJson(nodeState, maxDepth, 0);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
    }

    private static JsonNode convertNodeStateToJson(NodeState nodeState, int maxDepth, int currentDepth) {
        ObjectNode result = mapper.createObjectNode();
        if (maxDepth != -1 && currentDepth > maxDepth) {
            return result;
        }
        for (PropertyState propertyState : nodeState.getProperties()) {
            String name = propertyState.getName();
            Type<?> type = propertyState.getType();
            if (propertyState.isArray()) {
                ArrayNode arrayNode = mapper.createArrayNode();
                if (type == Type.STRINGS) {
                    propertyState.getValue(Type.STRINGS).forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
                } else if (type == Type.LONGS) {
                    propertyState.getValue(Type.LONGS).forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
                } else if (type == Type.DOUBLES) {
                    propertyState.getValue(Type.DOUBLES).forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
                } else if (type == Type.BOOLEANS) {
                    propertyState.getValue(Type.BOOLEANS).forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
                } else if (type == Type.DATES) {
                    propertyState.getValue(Type.DATES).forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
                } else if (type == Type.DECIMALS) {
                    propertyState.getValue(Type.DECIMALS).forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
                } else {
                    for (int i = 0; i < propertyState.count(); ++i) {
                        arrayNode.add(propertyState.getValue(Type.STRING, i));
                    }
                }
                result.set(name, (JsonNode)arrayNode);
                continue;
            }
            if (type == Type.STRING) {
                result.put(name, propertyState.getValue(Type.STRING));
                continue;
            }
            if (type == Type.LONG) {
                result.put(name, propertyState.getValue(Type.LONG));
                continue;
            }
            if (type == Type.DOUBLE) {
                result.put(name, propertyState.getValue(Type.DOUBLE));
                continue;
            }
            if (type == Type.BOOLEAN) {
                result.put(name, propertyState.getValue(Type.BOOLEAN));
                continue;
            }
            if (type == Type.DATE) {
                result.put(name, propertyState.getValue(Type.DATE).toString());
                continue;
            }
            if (type == Type.DECIMAL) {
                result.put(name, propertyState.getValue(Type.DECIMAL).toString());
                continue;
            }
            result.put(name, propertyState.getValue(Type.STRING));
        }
        for (String string : nodeState.getChildNodeNames()) {
            NodeState childNode = nodeState.getChildNode(string);
            result.set(string, JsonUtils.convertNodeStateToJson(childNode, maxDepth, currentDepth + 1));
        }
        return result;
    }

    public static boolean isValidJson(String text, boolean isJsonArray) {
        if (text == null) {
            return false;
        }
        JsopTokenizer reader = new JsopTokenizer(text);
        return JsonUtils.validateJson(reader, isJsonArray);
    }

    private static boolean validateJson(JsopReader reader, boolean isJsonArray) {
        if (reader.matches(123)) {
            return JsonUtils.validateObject(reader) && reader.read() == 0;
        }
        if (reader.matches(91)) {
            if (!isJsonArray) {
                return false;
            }
            return JsonUtils.validateArray(reader) && reader.read() == 0;
        }
        return false;
    }

    private static boolean validateObject(JsopReader reader) {
        boolean first = true;
        while (!reader.matches(125)) {
            if (!first && !reader.matches(44)) {
                return false;
            }
            if (!reader.matches(1)) {
                return false;
            }
            if (!reader.matches(58)) {
                return false;
            }
            if (!JsonUtils.readJsonValue(reader)) {
                return false;
            }
            first = false;
        }
        return true;
    }

    private static boolean validateArray(JsopReader reader) {
        boolean first = true;
        while (!reader.matches(93)) {
            if (!first && !reader.matches(44)) {
                return false;
            }
            if (!JsonUtils.readJsonValue(reader)) {
                return false;
            }
            first = false;
        }
        return true;
    }

    private static boolean readJsonValue(JsopReader reader) {
        int token = reader.read();
        switch (token) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
            case 123: {
                return JsonUtils.validateObject(reader);
            }
            case 91: {
                return JsonUtils.validateArray(reader);
            }
        }
        return false;
    }
}

