/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.hc;

import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.hc.annotation.HealthCheckService;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.contentloader.PathEntry;
import org.apache.sling.jcr.contentloader.internal.BundleHelper;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HealthCheckService(name="Bundle Content Loaded")
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class, factory=true)
public class BundleContentLoadedCheck
implements HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(BundleContentLoadedCheck.class);
    public static final String HC_NAME = "Bundle Content Loaded";
    public static final String HC_LABEL = "Health Check: Bundle Content Loaded";
    private BundleContext bundleContext;
    private Pattern includesRegex;
    private Pattern excludesRegex;
    boolean useCriticalForNotLoaded;
    @Reference
    private ServiceUserMapped serviceUserMapped;
    @Reference
    private SlingRepository repository;
    @Reference
    private BundleHelper bundleHelper;

    @Activate
    public void activate(BundleContext bundleContext, Config config) {
        this.bundleContext = bundleContext;
        this.includesRegex = Pattern.compile(config.includesRegex());
        String excludesRegex2 = config.excludesRegex();
        this.excludesRegex = excludesRegex2 != null && !excludesRegex2.isEmpty() ? Pattern.compile(excludesRegex2) : null;
        this.useCriticalForNotLoaded = config.useCriticalForNotLoaded();
        LOG.debug("Activated bundle content loaded HC for includesRegex={} excludesRegex={}% useCriticalForNotLoaded={}", new Object[]{this.includesRegex, this.excludesRegex, this.useCriticalForNotLoaded});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute() {
        String excludedMsg;
        FormattingResultLog log = new FormattingResultLog();
        Bundle[] bundles = this.bundleContext.getBundles();
        log.debug("Framwork has {} bundles in total", new Object[]{bundles.length});
        int countExcluded = 0;
        int relevantBundlesCount = 0;
        int notLoadedCount = 0;
        Session metadataSession = null;
        try {
            metadataSession = this.repository.loginService(null, null);
            for (Bundle bundle : bundles) {
                String bundleSymbolicName = bundle.getSymbolicName();
                if (!this.includesRegex.matcher(bundleSymbolicName).matches()) {
                    LOG.debug("Bundle {} not matched by {}", (Object)bundleSymbolicName, (Object)this.includesRegex);
                    continue;
                }
                if (this.excludesRegex != null && this.excludesRegex.matcher(bundleSymbolicName).matches()) {
                    LOG.debug("Bundle {} excluded {}", (Object)bundleSymbolicName, (Object)this.excludesRegex);
                    ++countExcluded;
                    continue;
                }
                Iterator<PathEntry> pathIter = PathEntry.getContentPaths(bundle);
                if (pathIter == null) {
                    log.debug("Bundle {} has no initial content", new Object[]{bundleSymbolicName});
                    continue;
                }
                ++relevantBundlesCount;
                Map<String, Object> bundleContentInfo = this.bundleHelper.getBundleContentInfo(metadataSession, bundle, false);
                if (bundleContentInfo == null) {
                    ++notLoadedCount;
                    String msg = "Not loaded bundle {} {}";
                    Object[] msgObjs = new Object[]{bundle.getBundleId(), bundleSymbolicName};
                    LOG.debug(msg, msgObjs);
                    if (this.useCriticalForNotLoaded) {
                        log.critical(msg, msgObjs);
                        continue;
                    }
                    log.warn(msg, msgObjs);
                    continue;
                }
                try {
                    boolean contentAlreadyLoaded = (Boolean)bundleContentInfo.get("content-loaded");
                    boolean isBundleUpdated = false;
                    Calendar lastLoadedAt = (Calendar)bundleContentInfo.get("content-load-time");
                    if (lastLoadedAt != null && lastLoadedAt.getTimeInMillis() < bundle.getLastModified()) {
                        isBundleUpdated = true;
                    }
                    if (!isBundleUpdated && contentAlreadyLoaded) {
                        log.debug("Content of bundle is already loaded {} {}.", new Object[]{bundle.getBundleId(), bundleSymbolicName});
                        continue;
                    }
                    ++notLoadedCount;
                    String msg = "Not loaded bundle {} {}";
                    Object[] msgObjs = new Object[]{bundle.getBundleId(), bundleSymbolicName};
                    LOG.debug(msg, msgObjs);
                    if (this.useCriticalForNotLoaded) {
                        log.critical(msg, msgObjs);
                        continue;
                    }
                    log.warn(msg, msgObjs);
                }
                finally {
                    this.bundleHelper.unlockBundleContentInfo(metadataSession, bundle, false, null);
                }
            }
        }
        catch (RepositoryException t) {
            String msg = "Unexpected error: " + t.getMessage();
            LOG.error(msg, (Throwable)t);
            log.critical(msg, new Object[0]);
        }
        finally {
            if (metadataSession != null) {
                try {
                    metadataSession.logout();
                }
                catch (Exception t) {
                    LOG.error("Unable to log out of session: " + t.getMessage(), (Throwable)t);
                }
            }
        }
        String baseMsg = relevantBundlesCount + " bundles" + (!this.includesRegex.pattern().equals(".*") ? " for pattern " + this.includesRegex.pattern() : "");
        String string = excludedMsg = countExcluded > 0 ? " (" + countExcluded + " excluded via pattern " + this.excludesRegex.pattern() + ")" : "";
        if (notLoadedCount > 0) {
            log.info("Found " + notLoadedCount + " not content loaded of " + baseMsg + excludedMsg, new Object[0]);
        } else {
            log.info("All " + baseMsg + " are content loaded" + excludedMsg, new Object[0]);
        }
        return new Result((ResultLog)log);
    }

    @ObjectClassDefinition(name="Health Check: Bundle Content Loaded", description="Checks the configured path(s) against the given thresholds")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="Name of this health check")
        public String hc_name() default "Bundle Content Loaded";

        @AttributeDefinition(name="Tags", description="List of tags for this health check, used to select subsets of health checks for execution e.g. by a composite health check.")
        public String[] hc_tags() default {};

        @AttributeDefinition(name="Includes RegEx", description="RegEx to select all relevant bundles for this check. The RegEx is matched against the symbolic name of the bundle.")
        public String includesRegex() default ".*";

        @AttributeDefinition(name="Excludes RegEx", description="Optional RegEx to exclude bundles from this check (matched against symbolic name). Allows to exclude specific bundles from selected set as produced by 'Includes RegEx'.")
        public String excludesRegex() default "";

        @AttributeDefinition(name="CRITICAL for not loaded bundles", description="By default not loaded bundles produce warnings, if this is set to true not loaded bundles produce a CRITICAL result")
        public boolean useCriticalForNotLoaded() default false;

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "Bundle content loaded includes: {includesRegex} excludes: {excludesRegex}";
    }
}

