/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.impl.felix.utils.resource;

import java.util.Collections;
import java.util.Map;
import org.apache.sling.feature.io.impl.felix.utils.resource.AbstractCapabilityRequirement;
import org.apache.sling.feature.io.impl.felix.utils.resource.CapabilitySet;
import org.apache.sling.feature.io.impl.felix.utils.resource.SimpleFilter;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class RequirementImpl
extends AbstractCapabilityRequirement
implements Requirement {
    private final SimpleFilter filter;
    private final boolean optional;

    public RequirementImpl(Resource res, String ns, Map<String, String> dirs, Map<String, Object> attrs) {
        this(res, ns, dirs, attrs, null);
    }

    public RequirementImpl(Resource res, String ns, String filter) {
        this(res, ns, filter == null ? Collections.emptyMap() : Collections.singletonMap("filter", filter), null);
    }

    public RequirementImpl(Resource resource, Requirement requirement) {
        this(resource, requirement.getNamespace(), requirement.getDirectives(), requirement.getAttributes());
    }

    public RequirementImpl(Resource resource, String path, Map<String, String> dirs, Map<String, Object> attrs, SimpleFilter sf) {
        super(resource, path, dirs, attrs);
        this.filter = sf == null ? RequirementImpl.getFilter(this.directives, this.attributes) : sf;
        this.optional = "optional".equals(this.directives.get("resolution"));
    }

    public boolean matches(Capability cap) {
        return CapabilitySet.matches(cap, this.getFilter());
    }

    public boolean isOptional() {
        return this.optional;
    }

    public SimpleFilter getFilter() {
        return this.filter;
    }

    public static boolean isOptional(Requirement requirement) {
        if (requirement instanceof RequirementImpl) {
            return ((RequirementImpl)requirement).isOptional();
        }
        return "optional".equals(requirement.getDirectives().get("resolution"));
    }

    public static SimpleFilter getFilter(Requirement requirement) {
        if (requirement instanceof RequirementImpl) {
            return ((RequirementImpl)requirement).getFilter();
        }
        return RequirementImpl.getFilter(requirement.getDirectives(), requirement.getAttributes());
    }

    private static SimpleFilter getFilter(Map<String, String> directives, Map<String, Object> attributes) {
        String filter = directives.get("filter");
        if (filter != null) {
            return SimpleFilter.parse(filter);
        }
        return SimpleFilter.convert(attributes);
    }
}

