/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.resources.impl;

import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.component.impl.DistributionComponentProvider;
import org.apache.sling.distribution.resources.impl.ExtendedDistributionServiceResourceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={ResourceProvider.class}, enabled=true, property={"webconsole.configurationFactory.nameHint=Resource kind: {kind}", "provider.ownsRoots:Boolean=true", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=Config.class, factory=true)
public class DistributionServiceResourceProviderFactory
implements ResourceProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private DistributionComponentProvider componentProvider;
    private ResourceProvider resourceProvider;

    @Activate
    public void activate(BundleContext context, Config conf) {
        this.log.debug("activating resource provider with config {}", (Object)conf);
        String kind = conf.kind();
        String resourceRoot = conf.provider_roots();
        this.resourceProvider = new ExtendedDistributionServiceResourceProvider(kind, this.componentProvider, resourceRoot);
        this.log.debug("created resource provider {}", (Object)this.resourceProvider);
    }

    @Deactivate
    public void deactivate(BundleContext context) {
        this.resourceProvider = null;
    }

    public Resource getResource(ResourceResolver resourceResolver, HttpServletRequest request, String path) {
        return this.getResource(resourceResolver, path);
    }

    public Resource getResource(ResourceResolver resourceResolver, String path) {
        return this.resourceProvider.getResource(resourceResolver, path);
    }

    public Iterator<Resource> listChildren(Resource parent) {
        return this.resourceProvider.listChildren(parent);
    }

    @ObjectClassDefinition(name="Apache Sling Distribution Resources - Service Resource Provider Factory", description="Distribution Service Resource Provider Factory")
    public static @interface Config {
        @AttributeDefinition
        public String provider_roots();

        @AttributeDefinition
        public String kind();
    }
}

