/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.vertx3;

import io.vertx.core.http.HttpClientRequest;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.vertx3.VertxContext;

public class HttpClientRequestImplInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) {
        HttpClientRequestContext requestContext = (HttpClientRequestContext)objInst.getSkyWalkingDynamicField();
        if (!requestContext.sent) {
            HttpClientRequest request = (HttpClientRequest)objInst;
            ContextCarrier contextCarrier = new ContextCarrier();
            AbstractSpan span = ContextManager.createExitSpan((String)HttpClientRequestImplInterceptor.toPath(request.uri()), (ContextCarrier)contextCarrier, (String)requestContext.remotePeer);
            span.setComponent((Component)ComponentsDefine.VERTX);
            SpanLayer.asHttp((AbstractSpan)span);
            Tags.HTTP.METHOD.set(span, request.method().toString());
            Tags.URL.set(span, request.uri());
            CarrierItem next = contextCarrier.items();
            while (next.hasNext()) {
                next = next.next();
                request.headers().add(next.getHeadKey(), next.getHeadValue());
            }
            requestContext.vertxContext = new VertxContext(ContextManager.capture(), span.prepareForAsync());
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) {
        HttpClientRequestContext requestContext = (HttpClientRequestContext)objInst.getSkyWalkingDynamicField();
        if (!requestContext.sent) {
            requestContext.sent = true;
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }

    private static String toPath(String uri) {
        int index = uri.indexOf("?");
        if (index > -1) {
            return uri.substring(0, index);
        }
        return uri;
    }

    static class HttpClientRequestContext {
        String remotePeer;
        boolean usingWebClient;
        VertxContext vertxContext;
        boolean sent;

        HttpClientRequestContext(String remotePeer) {
            this.remotePeer = remotePeer;
        }
    }

    public static class Version38PlusConstructorInterceptor
    implements InstanceConstructorInterceptor {
        public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
            String host = (String)allArguments[4];
            int port = (Integer)allArguments[5];
            objInst.setSkyWalkingDynamicField((Object)new HttpClientRequestContext(host + ":" + port));
        }
    }

    public static class Version34XTo37XConstructorInterceptor
    implements InstanceConstructorInterceptor {
        public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
            String host = (String)allArguments[3];
            int port = (Integer)allArguments[4];
            objInst.setSkyWalkingDynamicField((Object)new HttpClientRequestContext(host + ":" + port));
        }
    }

    public static class Version30XTo33XConstructorInterceptor
    implements InstanceConstructorInterceptor {
        public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
            String host = (String)allArguments[2];
            int port = (Integer)allArguments[3];
            objInst.setSkyWalkingDynamicField((Object)new HttpClientRequestContext(host + ":" + port));
        }
    }
}

