/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.stream;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.stream.FixedStreamMessage;
import com.linecorp.armeria.internal.common.stream.StreamMessageUtil;
import io.netty.util.concurrent.EventExecutor;
import java.util.List;

abstract class AbstractFixedStreamMessage<T>
extends FixedStreamMessage<T> {
    private int fulfilled;
    private boolean inOnNext;
    private boolean cancelled;
    private volatile int demand;

    AbstractFixedStreamMessage() {
    }

    @Override
    public final long demand() {
        return this.demand;
    }

    abstract T get(int var1);

    abstract int size();

    @Override
    final void cleanupObjects(@Nullable Throwable cause) {
        int size = this.size();
        while (this.fulfilled < size) {
            T obj = this.get(this.fulfilled++);
            StreamMessageUtil.closeOrAbort(obj, cause);
        }
    }

    @Override
    final List<T> drainAll(boolean withPooledObjects) {
        List<T> all = this.drainAll0(withPooledObjects);
        this.fulfilled = this.size();
        return all;
    }

    abstract List<T> drainAll0(boolean var1);

    public final void request(long n) {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.request0(n);
        } else {
            executor.execute(() -> this.request0(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void request0(long n) {
        if (this.isDone()) {
            return;
        }
        if (n <= 0L) {
            this.onError(new IllegalArgumentException("n: " + n + " (expected: > 0, see Reactive Streams specification rule 3.9)"));
            return;
        }
        int size = this.size();
        if (this.fulfilled == size) {
            return;
        }
        int oldDemand = this.demand;
        if (oldDemand >= size) {
            return;
        }
        int remaining = size - this.fulfilled;
        this.demand = n >= (long)remaining ? remaining : (int)Math.min((long)oldDemand + n, (long)remaining);
        if (this.inOnNext) {
            return;
        }
        do {
            if (this.cancelled) {
                return;
            }
            while (this.demand > 0 && this.fulfilled < size) {
                if (this.cancelled) {
                    return;
                }
                T o = this.get(this.fulfilled++);
                this.inOnNext = true;
                --this.demand;
                try {
                    this.onNext(o);
                }
                finally {
                    this.inOnNext = false;
                }
            }
            if (this.fulfilled != size) continue;
            this.onComplete();
            return;
        } while (this.demand != 0);
    }

    @Override
    public final void cancel() {
        if (this.isDone()) {
            return;
        }
        this.cancelled = true;
        super.cancel();
    }

    @Override
    public void abort() {
        if (this.isDone()) {
            return;
        }
        this.cancelled = true;
        super.abort();
    }

    @Override
    public void abort(Throwable cause) {
        if (this.isDone()) {
            return;
        }
        this.cancelled = true;
        super.abort(cause);
    }

    private boolean isDone() {
        return this.cancelled || this.isComplete();
    }
}

