/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import io.netty.util.AttributeKey;
import java.util.Objects;

public final class ClientPendingThrowableUtil {
    private static final AttributeKey<Throwable> CLIENT_PENDING_THROWABLE = AttributeKey.valueOf(ClientPendingThrowableUtil.class, "CLIENT_PENDING_THROWABLE");

    public static void setPendingThrowable(ClientRequestContext ctx, Throwable cause) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(cause, "cause");
        cause = Exceptions.peel(cause);
        ctx.setAttr(CLIENT_PENDING_THROWABLE, cause);
    }

    @Nullable
    public static Throwable pendingThrowable(ClientRequestContext ctx) {
        Objects.requireNonNull(ctx, "ctx");
        return ctx.attr(CLIENT_PENDING_THROWABLE);
    }

    public static void removePendingThrowable(ClientRequestContext ctx) {
        Objects.requireNonNull(ctx, "ctx");
        if (!ctx.hasAttr(CLIENT_PENDING_THROWABLE)) {
            return;
        }
        ctx.setAttr(CLIENT_PENDING_THROWABLE, null);
    }

    private ClientPendingThrowableUtil() {
    }
}

