/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.cache;

import com.google.common.primitives.Ints;
import com.orbitz.consul.CatalogClient;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.cache.CacheDescriptor;
import com.orbitz.consul.cache.ConsulCache;
import com.orbitz.consul.config.CacheConfig;
import com.orbitz.consul.model.catalog.CatalogService;
import com.orbitz.consul.option.QueryOptions;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class ServiceCatalogCache
extends ConsulCache<String, CatalogService> {
    private ServiceCatalogCache(CatalogClient catalogClient, String serviceName, QueryOptions queryOptions, int watchSeconds, ConsulCache.Scheduler callbackScheduler) {
        super(CatalogService::getServiceId, (BigInteger index, ConsulResponseCallback<List<V>> callback) -> {
            ServiceCatalogCache.checkWatch(catalogClient.getNetworkTimeoutConfig().getClientReadTimeoutMillis(), watchSeconds);
            catalogClient.getService(serviceName, ServiceCatalogCache.watchParams(index, watchSeconds, queryOptions), callback);
        }, catalogClient.getConfig().getCacheConfig(), catalogClient.getEventHandler(), new CacheDescriptor("catalog.service", serviceName), callbackScheduler);
    }

    public static ServiceCatalogCache newCache(CatalogClient catalogClient, String serviceName, QueryOptions queryOptions, int watchSeconds, ScheduledExecutorService callbackExecutorService) {
        ConsulCache.Scheduler scheduler = ServiceCatalogCache.createExternal(callbackExecutorService);
        return new ServiceCatalogCache(catalogClient, serviceName, queryOptions, watchSeconds, scheduler);
    }

    public static ServiceCatalogCache newCache(CatalogClient catalogClient, String serviceName, QueryOptions queryOptions, int watchSeconds) {
        return new ServiceCatalogCache(catalogClient, serviceName, queryOptions, watchSeconds, ServiceCatalogCache.createDefault());
    }

    public static ServiceCatalogCache newCache(CatalogClient catalogClient, String serviceName) {
        CacheConfig cacheConfig = catalogClient.getConfig().getCacheConfig();
        int watchSeconds = Ints.checkedCast((long)cacheConfig.getWatchDuration().getSeconds());
        return ServiceCatalogCache.newCache(catalogClient, serviceName, QueryOptions.BLANK, watchSeconds);
    }
}

