/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.query;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.QueryOrder;
import org.apache.skywalking.oap.server.core.query.type.Span;
import org.apache.skywalking.oap.server.core.query.type.TraceBrief;
import org.apache.skywalking.oap.server.core.query.type.TraceState;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.library.module.Service;

public interface ITraceQueryDAO
extends Service {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public TraceBrief queryBasicTracesDebuggable(Duration duration, long minDuration, long maxDuration, String serviceId, String serviceInstanceId, String endpointId, String traceId, int limit, int from, TraceState traceState, QueryOrder queryOrder, List<Tag> tags) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            StringBuilder builder = new StringBuilder();
            if (traceContext != null) {
                span = traceContext.createSpan("Query Dao: queryBasicTraces");
                builder.append("Condition: Duration: ").append(duration).append(", MinDuration: ").append(minDuration).append(", MaxDuration: ").append(maxDuration).append(", ServiceId: ").append(serviceId).append(", ServiceInstanceId: ").append(serviceInstanceId).append(", EndpointId: ").append(endpointId).append(", TraceId: ").append(traceId).append(", Limit: ").append(limit).append(", From: ").append(from).append(", TraceState: ").append((Object)traceState).append(", QueryOrder: ").append((Object)queryOrder).append(", Tags: ").append(tags);
                span.setMsg(builder.toString());
            }
            TraceBrief traceBrief = this.queryBasicTraces(duration, minDuration, maxDuration, serviceId, serviceInstanceId, endpointId, traceId, limit, from, traceState, queryOrder, tags);
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
            return traceBrief;
        }
        catch (Throwable throwable) {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<SegmentRecord> queryByTraceIdDebuggable(String traceId, @Nullable Duration duration) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            StringBuilder builder = new StringBuilder();
            if (traceContext != null) {
                span = traceContext.createSpan("Query Dao: queryByTraceId");
                builder.append("Condition: TraceId: ").append(traceId);
                span.setMsg(builder.toString());
            }
            List<SegmentRecord> list = this.queryByTraceId(traceId, duration);
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
            return list;
        }
        catch (Throwable throwable) {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
            throw throwable;
        }
    }

    public TraceBrief queryBasicTraces(Duration var1, long var2, long var4, String var6, String var7, String var8, String var9, int var10, int var11, TraceState var12, QueryOrder var13, List<Tag> var14) throws IOException;

    public List<SegmentRecord> queryByTraceId(String var1, @Nullable Duration var2) throws IOException;

    public List<SegmentRecord> queryBySegmentIdList(List<String> var1, @Nullable Duration var2) throws IOException;

    public List<SegmentRecord> queryByTraceIdWithInstanceId(List<String> var1, List<String> var2, @Nullable Duration var3) throws IOException;

    public List<Span> doFlexibleTraceQuery(String var1) throws IOException;
}

