/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.source;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.source.ScopeDefaultColumn;
import org.apache.skywalking.oap.server.core.source.SideCar;
import org.apache.skywalking.oap.server.core.source.Source;
import org.apache.skywalking.oap.server.library.util.StringUtil;

@ScopeDeclaration(id=60, name="TCPServiceInstanceRelation", catalog="SERVICE_INSTANCE_RELATION")
@ScopeDefaultColumn.VirtualColumnDefinition(fieldName="entityId", columnName="entity_id", isID=true, type=String.class)
public class TCPServiceInstanceRelation
extends Source {
    private String entityId;
    private String sourceServiceInstanceId;
    private String sourceServiceId;
    @ScopeDefaultColumn.DefinedByField(columnName="source_service_name", requireDynamicActive=true)
    private String sourceServiceName;
    private Layer sourceServiceLayer;
    @ScopeDefaultColumn.DefinedByField(columnName="source_service_instance_name", requireDynamicActive=true)
    private String sourceServiceInstanceName;
    private String destServiceInstanceId;
    private String destServiceId;
    private Layer destServiceLayer;
    @ScopeDefaultColumn.DefinedByField(columnName="dest_service_name", requireDynamicActive=true)
    private String destServiceName;
    @ScopeDefaultColumn.DefinedByField(columnName="dest_service_instance_name", requireDynamicActive=true)
    private String destServiceInstanceName;
    private int componentId;
    private DetectPoint detectPoint;
    private String tlsMode;
    private SideCar sideCar = new SideCar();
    private long receivedBytes;
    private long sentBytes;

    @Override
    public int scope() {
        return 60;
    }

    @Override
    public String getEntityId() {
        if (StringUtil.isEmpty((String)this.entityId)) {
            this.entityId = IDManager.ServiceInstanceID.buildRelationId(new IDManager.ServiceInstanceID.ServiceInstanceRelationDefine(this.sourceServiceInstanceId, this.destServiceInstanceId));
        }
        return this.entityId;
    }

    @Override
    public void prepare() {
        this.sourceServiceId = IDManager.ServiceID.buildId(this.sourceServiceName, this.sourceServiceLayer.isNormal());
        this.destServiceId = IDManager.ServiceID.buildId(this.destServiceName, this.destServiceLayer.isNormal());
        this.sourceServiceInstanceId = IDManager.ServiceInstanceID.buildId(this.sourceServiceId, this.sourceServiceInstanceName);
        this.destServiceInstanceId = IDManager.ServiceInstanceID.buildId(this.destServiceId, this.destServiceInstanceName);
    }

    @Generated
    public String getSourceServiceInstanceId() {
        return this.sourceServiceInstanceId;
    }

    @Generated
    public String getSourceServiceId() {
        return this.sourceServiceId;
    }

    @Generated
    public String getSourceServiceName() {
        return this.sourceServiceName;
    }

    @Generated
    public void setSourceServiceName(String sourceServiceName) {
        this.sourceServiceName = sourceServiceName;
    }

    @Generated
    public Layer getSourceServiceLayer() {
        return this.sourceServiceLayer;
    }

    @Generated
    public void setSourceServiceLayer(Layer sourceServiceLayer) {
        this.sourceServiceLayer = sourceServiceLayer;
    }

    @Generated
    public String getSourceServiceInstanceName() {
        return this.sourceServiceInstanceName;
    }

    @Generated
    public void setSourceServiceInstanceName(String sourceServiceInstanceName) {
        this.sourceServiceInstanceName = sourceServiceInstanceName;
    }

    @Generated
    public String getDestServiceInstanceId() {
        return this.destServiceInstanceId;
    }

    @Generated
    public String getDestServiceId() {
        return this.destServiceId;
    }

    @Generated
    public Layer getDestServiceLayer() {
        return this.destServiceLayer;
    }

    @Generated
    public void setDestServiceLayer(Layer destServiceLayer) {
        this.destServiceLayer = destServiceLayer;
    }

    @Generated
    public String getDestServiceName() {
        return this.destServiceName;
    }

    @Generated
    public void setDestServiceName(String destServiceName) {
        this.destServiceName = destServiceName;
    }

    @Generated
    public String getDestServiceInstanceName() {
        return this.destServiceInstanceName;
    }

    @Generated
    public void setDestServiceInstanceName(String destServiceInstanceName) {
        this.destServiceInstanceName = destServiceInstanceName;
    }

    @Generated
    public int getComponentId() {
        return this.componentId;
    }

    @Generated
    public void setComponentId(int componentId) {
        this.componentId = componentId;
    }

    @Generated
    public DetectPoint getDetectPoint() {
        return this.detectPoint;
    }

    @Generated
    public void setDetectPoint(DetectPoint detectPoint) {
        this.detectPoint = detectPoint;
    }

    @Generated
    public String getTlsMode() {
        return this.tlsMode;
    }

    @Generated
    public void setTlsMode(String tlsMode) {
        this.tlsMode = tlsMode;
    }

    @Generated
    public SideCar getSideCar() {
        return this.sideCar;
    }

    @Generated
    public void setSideCar(SideCar sideCar) {
        this.sideCar = sideCar;
    }

    @Generated
    public long getReceivedBytes() {
        return this.receivedBytes;
    }

    @Generated
    public void setReceivedBytes(long receivedBytes) {
        this.receivedBytes = receivedBytes;
    }

    @Generated
    public long getSentBytes() {
        return this.sentBytes;
    }

    @Generated
    public void setSentBytes(long sentBytes) {
        this.sentBytes = sentBytes;
    }
}

