/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.oal.rt;

import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.StreamAnnotationListener;
import org.apache.skywalking.oap.server.core.oal.rt.OALCompileException;
import org.apache.skywalking.oap.server.core.oal.rt.OALDefine;
import org.apache.skywalking.oap.server.core.oal.rt.OALEngine;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.core.storage.StorageBuilderFactory;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OALEngineLoaderService
implements Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OALEngineLoaderService.class);
    private final Set<OALDefine> oalDefineSet = new HashSet<OALDefine>();
    private final ModuleManager moduleManager;

    public void load(OALDefine define) throws ModuleStartException {
        if (this.oalDefineSet.contains(define)) {
            return;
        }
        try {
            OALEngine engine = OALEngineLoaderService.loadOALEngine(define);
            StreamAnnotationListener streamAnnotationListener = new StreamAnnotationListener((ModuleDefineHolder)this.moduleManager);
            engine.setStreamListener(streamAnnotationListener);
            engine.setDispatcherListener(((SourceReceiver)this.moduleManager.find("core").provider().getService(SourceReceiver.class)).getDispatcherDetectorListener());
            engine.setStorageBuilderFactory((StorageBuilderFactory)this.moduleManager.find("storage").provider().getService(StorageBuilderFactory.class));
            engine.start(OALEngineLoaderService.class.getClassLoader());
            engine.notifyAllListeners();
            this.oalDefineSet.add(define);
        }
        catch (ReflectiveOperationException | OALCompileException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    private static OALEngine loadOALEngine(OALDefine define) throws ReflectiveOperationException {
        Class<?> engineRTClass = Class.forName("org.apache.skywalking.oal.rt.OALRuntime");
        Constructor<?> engineRTConstructor = engineRTClass.getConstructor(OALDefine.class);
        return (OALEngine)engineRTConstructor.newInstance(define);
    }

    @Generated
    public OALEngineLoaderService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }
}

