/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.config.group;

import java.io.FileNotFoundException;
import java.io.StringReader;
import lombok.Generated;
import org.apache.skywalking.oap.server.configuration.api.ConfigChangeWatcher;
import org.apache.skywalking.oap.server.core.config.group.EndpointGroupingRuleReader;
import org.apache.skywalking.oap.server.core.config.group.EndpointNameGrouping;
import org.apache.skywalking.oap.server.core.config.group.uri.quickmatch.QuickUriGroupingRule;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointNameGroupingRuleWatcher
extends ConfigChangeWatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EndpointNameGroupingRuleWatcher.class);
    private final EndpointNameGrouping grouping;
    private volatile String ruleSetting;

    public EndpointNameGroupingRuleWatcher(ModuleProvider provider, EndpointNameGrouping grouping) throws FileNotFoundException {
        super("core", provider, "endpoint-name-grouping");
        this.grouping = grouping;
        this.ruleSetting = "SkyWalking endpoint rule";
        grouping.setEndpointGroupingRule(new EndpointGroupingRuleReader(ResourceUtils.read((String)"endpoint-name-grouping.yml")).read());
    }

    public void notify(ConfigChangeWatcher.ConfigChangeEvent value) {
        if (value.getEventType().equals((Object)ConfigChangeWatcher.EventType.DELETE)) {
            this.ruleSetting = null;
            this.grouping.setEndpointGroupingRule(new QuickUriGroupingRule());
        } else {
            this.ruleSetting = value.getNewValue();
            this.grouping.setEndpointGroupingRule(new EndpointGroupingRuleReader(new StringReader(this.ruleSetting)).read());
        }
    }

    public String value() {
        return this.ruleSetting;
    }
}

