/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.server.HttpServiceWithRoutes;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.grpc.GrpcRequestUtil;
import com.linecorp.armeria.server.grpc.GrpcServiceBuilder;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public interface GrpcService
extends HttpServiceWithRoutes {
    public static GrpcServiceBuilder builder() {
        return new GrpcServiceBuilder();
    }

    public boolean isFramed();

    public List<ServerServiceDefinition> services();

    @Nullable
    @UnstableApi
    default public ServerMethodDefinition<?, ?> methodDefinition(ServiceRequestContext ctx) {
        Route mappedRoute = ctx.config().mappedRoute();
        ServerMethodDefinition<?, ?> method = this.methodsByRoute().get(mappedRoute);
        if (method != null) {
            return method;
        }
        String methodName = GrpcRequestUtil.determineMethod(ctx);
        if (methodName == null) {
            return null;
        }
        return this.methods().get(methodName);
    }

    default public Map<String, ServerMethodDefinition<?, ?>> methods() {
        return (Map)this.services().stream().flatMap(service -> service.getMethods().stream()).distinct().collect(ImmutableMap.toImmutableMap(method -> method.getMethodDescriptor().getFullMethodName(), Function.identity()));
    }

    public Map<Route, ServerMethodDefinition<?, ?>> methodsByRoute();

    public Set<SerializationFormat> supportedSerializationFormats();

    default public boolean shouldCachePath(String path, @Nullable String query, Route route) {
        return true;
    }
}

