/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.metrics.lookout;

import com.alipay.lookout.api.Id;
import com.alipay.lookout.api.Lookout;
import com.alipay.sofa.rpc.config.ServerConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class RpcLookoutId {
    private final ConcurrentMap<String, Id> consumerIds = new ConcurrentHashMap<String, Id>();
    private final ConcurrentMap<String, Id> providerIds = new ConcurrentHashMap<String, Id>();
    private final ConcurrentMap<String, Id> serverConfigIds = new ConcurrentHashMap<String, Id>();
    private volatile Id consumerConfigId;
    private volatile Id providerConfigId;
    private static final Lock classLock = new ReentrantLock();
    private final Lock consumerConfigIdLock = new ReentrantLock();
    private final Lock providerConfigIdLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Id fetchConsumerStatId(Map<String, String> tags) {
        String key = tags.toString();
        Id lookoutId = (Id)this.consumerIds.get(key);
        if (lookoutId == null) {
            classLock.lock();
            try {
                lookoutId = (Id)this.consumerIds.get(key);
                if (lookoutId == null) {
                    lookoutId = Lookout.registry().createId("rpc.consumer.service.stats", tags);
                    this.consumerIds.put(key, lookoutId);
                }
            }
            finally {
                classLock.unlock();
            }
        }
        return lookoutId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Id fetchProviderStatId(Map<String, String> tags) {
        String key = tags.toString();
        Id lookoutId = (Id)this.providerIds.get(key);
        if (lookoutId == null) {
            classLock.lock();
            try {
                lookoutId = (Id)this.providerIds.get(key);
                if (lookoutId == null) {
                    lookoutId = Lookout.registry().createId("rpc.provider.service.stats", tags);
                    this.providerIds.put(key, lookoutId);
                }
            }
            finally {
                classLock.unlock();
            }
        }
        return lookoutId;
    }

    public Id fetchConsumerSubId() {
        if (this.consumerConfigId == null) {
            this.consumerConfigIdLock.lock();
            try {
                if (this.consumerConfigId == null) {
                    this.consumerConfigId = Lookout.registry().createId("rpc.consumer.info.stats");
                }
            }
            finally {
                this.consumerConfigIdLock.unlock();
            }
        }
        return this.consumerConfigId;
    }

    public Id fetchProviderPubId() {
        if (this.providerConfigId == null) {
            this.providerConfigIdLock.lock();
            try {
                if (this.providerConfigId == null) {
                    this.providerConfigId = Lookout.registry().createId("rpc.provider.info.stats");
                }
            }
            finally {
                this.providerConfigIdLock.unlock();
            }
        }
        return this.providerConfigId;
    }

    public synchronized Id fetchServerThreadConfigId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.config";
        return this.fetchServerConfigId(key);
    }

    public Id fetchServerThreadPoolActiveCountId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.active.count";
        return this.fetchServerConfigId(key);
    }

    public Id fetchServerThreadPoolIdleCountId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.idle.count";
        return this.fetchServerConfigId(key);
    }

    public Id fetchServerThreadPoolQueueSizeId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.queue.size";
        return this.fetchServerConfigId(key);
    }

    private Id fetchServerConfigId(String key) {
        Id lookoutId = (Id)this.serverConfigIds.get(key);
        if (lookoutId == null) {
            classLock.lock();
            try {
                lookoutId = (Id)this.serverConfigIds.get(key);
                if (lookoutId == null) {
                    lookoutId = Lookout.registry().createId(key);
                    this.serverConfigIds.put(key, lookoutId);
                }
            }
            finally {
                classLock.unlock();
            }
        }
        return lookoutId;
    }

    public Id removeServerThreadConfigId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.config";
        return (Id)this.serverConfigIds.remove(key);
    }

    public Id removeServerThreadPoolActiveCountId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.active.count";
        return (Id)this.serverConfigIds.remove(key);
    }

    public Id removeServerThreadPoolIdleCountId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.idle.count";
        return (Id)this.serverConfigIds.remove(key);
    }

    public Id removeServerThreadPoolQueueSizeId(ServerConfig serverConfig) {
        String key = "rpc." + serverConfig.getProtocol() + ".threadpool.queue.size";
        return (Id)this.serverConfigIds.remove(key);
    }
}

