/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc;

import java.util.concurrent.Executor;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.CancellationListener;
import org.apache.dubbo.rpc.RpcServiceContext;

public class ExecutableListener
implements Runnable {
    private static final ErrorTypeAwareLogger log = LoggerFactory.getErrorTypeAwareLogger(ExecutableListener.class);
    private final Executor executor;
    private final CancellationListener listener;
    private final RpcServiceContext context;

    public ExecutableListener(Executor executor, CancellationListener listener, RpcServiceContext context) {
        this.executor = executor;
        this.listener = listener;
        this.context = context;
    }

    public ExecutableListener(Executor executor, CancellationListener listener) {
        this(executor, listener, null);
    }

    public void deliver() {
        try {
            this.executor.execute(this);
        }
        catch (Throwable t) {
            log.warn("0-9", "", "", "Exception notifying context listener", t);
        }
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public CancellationListener getListener() {
        return this.listener;
    }

    public RpcServiceContext getContext() {
        return this.context;
    }

    @Override
    public void run() {
        this.listener.cancelled(this.context);
    }
}

