/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.loadbalancer.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.utils.MapUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.loadbalancer.cache.UpstreamCheckTask;
import org.apache.shenyu.loadbalancer.entity.Upstream;

public final class UpstreamCacheManager {
    private static final UpstreamCacheManager INSTANCE = new UpstreamCacheManager();
    private static final Map<String, List<Upstream>> UPSTREAM_MAP = Maps.newConcurrentMap();
    private UpstreamCheckTask task;
    private Boolean checkEnable;
    private int poolSize;
    private int checkTimeout;
    private int checkInterval;
    private int healthyThreshold;
    private int unhealthyThreshold;
    private Boolean printEnable;
    private Integer printInterval;

    private UpstreamCacheManager() {
        this.initHealthCheck();
    }

    private void initHealthCheck() {
        ShenyuConfig shenyuConfig = Optional.ofNullable((ShenyuConfig)Singleton.INST.get(ShenyuConfig.class)).orElse(new ShenyuConfig());
        ShenyuConfig.UpstreamCheck upstreamCheck = shenyuConfig.getUpstreamCheck();
        this.checkEnable = upstreamCheck.getEnabled();
        this.poolSize = upstreamCheck.getPoolSize();
        this.checkTimeout = upstreamCheck.getTimeout();
        this.healthyThreshold = upstreamCheck.getHealthyThreshold();
        this.unhealthyThreshold = upstreamCheck.getUnhealthyThreshold();
        this.checkInterval = upstreamCheck.getInterval();
        this.printEnable = upstreamCheck.getPrintEnabled();
        this.printInterval = upstreamCheck.getPrintInterval();
        this.createTask();
        this.scheduleHealthCheck();
    }

    private void createTask() {
        this.task = new UpstreamCheckTask(this.checkInterval);
        this.task.setPoolSize(this.poolSize);
        this.task.setCheckTimeout(this.checkTimeout);
        this.task.setHealthyThreshold(this.healthyThreshold);
        this.task.setUnhealthyThreshold(this.unhealthyThreshold);
    }

    private void scheduleHealthCheck() {
        if (this.checkEnable.booleanValue()) {
            this.task.schedule();
            if (this.printEnable.booleanValue()) {
                ThreadFactory printFactory = ShenyuThreadFactory.create((String)"upstream-health-print", (boolean)true);
                new ScheduledThreadPoolExecutor(1, printFactory).scheduleWithFixedDelay(this.task::print, this.printInterval.intValue(), this.printInterval.intValue(), TimeUnit.MILLISECONDS);
            }
        }
    }

    public static UpstreamCacheManager getInstance() {
        return INSTANCE;
    }

    public List<Upstream> findUpstreamListBySelectorId(String selectorId) {
        return this.task.getHealthyUpstream().get(selectorId);
    }

    public void removeByKey(String key) {
        UPSTREAM_MAP.remove(key);
        this.task.triggerRemoveAll(key);
    }

    public void submit(String selectorId, List<Upstream> upstreamList) {
        List<Upstream> healthyUpstreamList;
        List<Object> actualUpstreamList = Objects.isNull(upstreamList) ? Lists.newArrayList() : upstreamList;
        Map<Boolean, List<Upstream>> partitionedUpstreams = actualUpstreamList.stream().collect(Collectors.partitioningBy(Upstream::isStatus));
        List<Upstream> validUpstreamList = partitionedUpstreams.get(true);
        List<Upstream> offlineUpstreamList = partitionedUpstreams.get(false);
        List existUpstreamList = (List)MapUtils.computeIfAbsent(UPSTREAM_MAP, (Object)selectorId, k -> Lists.newArrayList());
        if (actualUpstreamList.isEmpty()) {
            existUpstreamList.forEach(up -> this.task.triggerRemoveOne(selectorId, (Upstream)up));
        }
        HashSet existUpstreamSet = new HashSet(existUpstreamList);
        offlineUpstreamList.forEach(offlineUp -> {
            if (existUpstreamSet.contains(offlineUp)) {
                this.task.triggerRemoveOne(selectorId, (Upstream)offlineUp);
            }
        });
        if (!validUpstreamList.isEmpty()) {
            Map<String, Upstream> existUpstreamMap = existUpstreamList.stream().collect(Collectors.toMap(this::upstreamMapKey, existUp -> existUp, (existing, replacement) -> existing));
            validUpstreamList.forEach(validUp -> {
                String key = this.upstreamMapKey((Upstream)validUp);
                Upstream matchedExistUp = (Upstream)existUpstreamMap.get(key);
                if (Objects.nonNull(matchedExistUp)) {
                    matchedExistUp.setWeight(validUp.getWeight());
                }
            });
            validUpstreamList.stream().filter(validUp -> !existUpstreamList.contains(validUp)).forEach(up -> this.task.triggerAddOne(selectorId, (Upstream)up));
        }
        UPSTREAM_MAP.put(selectorId, (List<Upstream>)(Objects.isNull(healthyUpstreamList = this.task.getHealthyUpstreamListBySelectorId(selectorId)) ? Lists.newArrayList() : healthyUpstreamList));
    }

    private String upstreamMapKey(Upstream upstream) {
        return String.join((CharSequence)"_", upstream.getProtocol(), upstream.getUrl());
    }
}

