/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze.type;

import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.type.BreezeType;
import com.weibo.breeze.type.TypeFloat64;
import com.weibo.breeze.type.TypeInt32;
import com.weibo.breeze.type.TypeInt64;
import com.weibo.breeze.type.TypeString;

public class TypeFloat32
implements BreezeType<Float> {
    TypeFloat32() {
    }

    public static float readFloat32(BreezeBuffer buffer) {
        return buffer.getFloat();
    }

    @Override
    public byte getType() {
        return -97;
    }

    @Override
    public Float read(BreezeBuffer buffer, boolean withType) throws BreezeException {
        if (!withType) {
            return Float.valueOf(TypeFloat32.readFloat32(buffer));
        }
        byte type = buffer.get();
        switch (type) {
            case -97: {
                return Float.valueOf(TypeFloat32.readFloat32(buffer));
            }
            case -96: {
                return Float.valueOf((float)TypeFloat64.readFloat64(buffer));
            }
            case 63: {
                return Float.valueOf(Float.parseFloat(TypeString.readString(buffer)));
            }
            case 127: {
                return Float.valueOf(TypeInt32.readInt32(buffer));
            }
            case -104: {
                return Float.valueOf(TypeInt64.readInt64(buffer));
            }
        }
        throw new BreezeException("Breeze cannot convert to Float. type: " + type);
    }

    @Override
    public void write(BreezeBuffer buffer, Float value, boolean withType) throws BreezeException {
        if (withType) {
            buffer.put((byte)-97);
        }
        buffer.putFloat(value.floatValue());
    }

    @Override
    public void writeMessageField(BreezeBuffer buffer, int index, Float field, boolean withType, boolean checkDefault) throws BreezeException {
        if (field != null) {
            if (checkDefault && field.floatValue() == 0.0f) {
                return;
            }
            buffer.putVarint(index);
            this.write(buffer, field, withType);
        }
    }
}

