/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.lifecycle.internal.reg;

import com.google.common.base.Strings;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperConfiguration;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperRegistryCenter;

public final class RegistryCenterFactory {
    private static final Map<HashCode, CoordinatorRegistryCenter> REG_CENTER_REGISTRY = new ConcurrentHashMap<HashCode, CoordinatorRegistryCenter>();

    public static CoordinatorRegistryCenter createCoordinatorRegistryCenter(String connectString, String namespace, String digest) {
        Hasher hasher = Hashing.sha256().newHasher().putString((CharSequence)connectString, StandardCharsets.UTF_8).putString((CharSequence)namespace, StandardCharsets.UTF_8);
        if (!Strings.isNullOrEmpty((String)digest)) {
            hasher.putString((CharSequence)digest, StandardCharsets.UTF_8);
        }
        HashCode hashCode = hasher.hash();
        return REG_CENTER_REGISTRY.computeIfAbsent(hashCode, unused -> {
            CoordinatorRegistryCenter result = RegistryCenterFactory.newCoordinatorRegistryCenter(connectString, namespace, digest);
            result.init();
            return result;
        });
    }

    private static CoordinatorRegistryCenter newCoordinatorRegistryCenter(String connectString, String namespace, String digest) {
        ZookeeperConfiguration zkConfig = new ZookeeperConfiguration(connectString, namespace);
        if (!Strings.isNullOrEmpty((String)digest)) {
            zkConfig.setDigest(digest);
        }
        return new ZookeeperRegistryCenter(zkConfig);
    }

    @Generated
    private RegistryCenterFactory() {
    }
}

