/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.ui.web.controller;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.domain.JobBriefInfo;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.domain.ShardingInfo;
import org.apache.shardingsphere.elasticjob.lite.ui.service.JobAPIService;
import org.apache.shardingsphere.elasticjob.lite.ui.util.SessionRegistryCenterConfiguration;
import org.apache.shardingsphere.elasticjob.lite.ui.web.response.ResponseResult;
import org.apache.shardingsphere.elasticjob.lite.ui.web.response.ResponseResultUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/jobs"})
public final class JobOperationController {
    private JobAPIService jobAPIService;

    @Autowired
    public JobOperationController(JobAPIService jobAPIService) {
        this.jobAPIService = jobAPIService;
    }

    @GetMapping(value={"/count"})
    public int getJobsTotalCount() {
        return this.jobAPIService.getJobStatisticsAPI().getJobsTotalCount();
    }

    @GetMapping(value={"/getAllJobsBriefInfo"})
    public ResponseResult<Collection<JobBriefInfo>> getAllJobsBriefInfo() {
        List data = Objects.nonNull(SessionRegistryCenterConfiguration.getRegistryCenterConfiguration()) ? this.jobAPIService.getJobStatisticsAPI().getAllJobsBriefInfo() : Collections.emptyList();
        return ResponseResultUtil.build(data);
    }

    @PostMapping(value={"/{jobName}/trigger"})
    public ResponseResult<Boolean> triggerJob(@PathVariable(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().trigger(jobName);
        return ResponseResultUtil.build(Boolean.TRUE);
    }

    @PostMapping(value={"/{jobName}/disable"})
    public ResponseResult<Boolean> disableJob(@PathVariable(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().disable(jobName, null);
        return ResponseResultUtil.build(Boolean.TRUE);
    }

    @PostMapping(value={"/{jobName}/enable"})
    public ResponseResult<Boolean> enableJob(@PathVariable(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().enable(jobName, null);
        return ResponseResultUtil.build(Boolean.TRUE);
    }

    @PostMapping(value={"/{jobName}/shutdown"})
    public ResponseResult<Boolean> shutdownJob(@PathVariable(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().shutdown(jobName, null);
        return ResponseResultUtil.build(Boolean.TRUE);
    }

    @GetMapping(value={"/{jobName}/sharding"})
    public ResponseResult<Collection<ShardingInfo>> getShardingInfo(@PathVariable(value="jobName") String jobName) {
        Collection data = this.jobAPIService.getShardingStatisticsAPI().getShardingInfo(jobName);
        return ResponseResultUtil.build(data);
    }

    @PostMapping(value={"/{jobName}/sharding/{item}/disable"})
    public ResponseResult<Boolean> disableSharding(@PathVariable(value="jobName") String jobName, @PathVariable(value="item") String item) {
        this.jobAPIService.getShardingOperateAPI().disable(jobName, item);
        return ResponseResultUtil.build(Boolean.TRUE);
    }

    @PostMapping(value={"/{jobName}/sharding/{item}/enable"})
    public ResponseResult<Boolean> enableSharding(@PathVariable(value="jobName") String jobName, @PathVariable(value="item") String item) {
        this.jobAPIService.getShardingOperateAPI().enable(jobName, item);
        return ResponseResultUtil.build(Boolean.TRUE);
    }
}

