/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.ui.domain;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.elasticjob.lite.ui.domain.EventTraceDataSource;
import org.apache.shardingsphere.elasticjob.lite.ui.domain.EventTraceDataSourceConfiguration;

public final class EventTraceDataSourceFactory {
    private static final ConcurrentHashMap<HashCode, EventTraceDataSource> DATA_SOURCE_REGISTRY = new ConcurrentHashMap();

    public static EventTraceDataSource createEventTraceDataSource(String driverClassName, String url, String username, String password) {
        HashCode hashCode;
        EventTraceDataSource result;
        Hasher hasher = Hashing.sha256().newHasher().putString((CharSequence)driverClassName, Charsets.UTF_8).putString((CharSequence)url, Charsets.UTF_8);
        if (!Strings.isNullOrEmpty((String)username)) {
            hasher.putString((CharSequence)username, Charsets.UTF_8);
        }
        if (null != password) {
            hasher.putString((CharSequence)password, Charsets.UTF_8);
        }
        if (null != (result = DATA_SOURCE_REGISTRY.get(hashCode = hasher.hash()))) {
            return result;
        }
        EventTraceDataSourceConfiguration eventTraceDataSourceConfiguration = new EventTraceDataSourceConfiguration(driverClassName, url, username, password);
        result = new EventTraceDataSource(eventTraceDataSourceConfiguration);
        result.init();
        DATA_SOURCE_REGISTRY.put(hashCode, result);
        return result;
    }

    private EventTraceDataSourceFactory() {
    }
}

