/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.reg.zookeeper;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.TransactionOp;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.base.LeaderExecutionCallback;
import org.apache.shardingsphere.elasticjob.reg.base.transaction.TransactionOperation;
import org.apache.shardingsphere.elasticjob.reg.exception.RegException;
import org.apache.shardingsphere.elasticjob.reg.exception.RegExceptionHandler;
import org.apache.shardingsphere.elasticjob.reg.listener.ConnectionStateChangedEventListener;
import org.apache.shardingsphere.elasticjob.reg.listener.DataChangedEvent;
import org.apache.shardingsphere.elasticjob.reg.listener.DataChangedEventListener;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperConfiguration;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZookeeperRegistryCenter
implements CoordinatorRegistryCenter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZookeeperRegistryCenter.class);
    private final ZookeeperConfiguration zkConfig;
    private final Map<String, CuratorCache> caches = new ConcurrentHashMap<String, CuratorCache>();
    private CuratorFramework client;

    public ZookeeperRegistryCenter(ZookeeperConfiguration zkConfig) {
        this.zkConfig = zkConfig;
    }

    public void init() {
        log.debug("Elastic job: zookeeper registry center init, server lists is: {}.", (Object)this.zkConfig.getServerLists());
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(this.zkConfig.getServerLists()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(this.zkConfig.getBaseSleepTimeMilliseconds(), this.zkConfig.getMaxRetries(), this.zkConfig.getMaxSleepTimeMilliseconds())).namespace(this.zkConfig.getNamespace());
        if (0 != this.zkConfig.getSessionTimeoutMilliseconds()) {
            builder.sessionTimeoutMs(this.zkConfig.getSessionTimeoutMilliseconds());
        }
        if (0 != this.zkConfig.getConnectionTimeoutMilliseconds()) {
            builder.connectionTimeoutMs(this.zkConfig.getConnectionTimeoutMilliseconds());
        }
        if (!Strings.isNullOrEmpty((String)this.zkConfig.getDigest())) {
            builder.authorization("digest", this.zkConfig.getDigest().getBytes(StandardCharsets.UTF_8)).aclProvider(new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }

                public List<ACL> getAclForPath(String path) {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }
            });
        }
        this.client = builder.build();
        this.client.start();
        try {
            if (!this.client.blockUntilConnected(this.zkConfig.getMaxSleepTimeMilliseconds() * this.zkConfig.getMaxRetries(), TimeUnit.MILLISECONDS)) {
                this.client.close();
                throw new KeeperException.OperationTimeoutException();
            }
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException((Exception)ex);
        }
    }

    public void close() {
        for (Map.Entry<String, CuratorCache> each : this.caches.entrySet()) {
            each.getValue().close();
        }
        this.waitForCacheClose();
        CloseableUtils.closeQuietly((Closeable)this.client);
    }

    private void waitForCacheClose() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public String get(String key) {
        CuratorCache cache = this.findCuratorCache(key);
        if (null == cache) {
            return this.getDirectly(key);
        }
        Optional resultInCache = cache.get(key);
        return resultInCache.map(v -> null == v.getData() ? null : new String(v.getData(), StandardCharsets.UTF_8)).orElseGet(() -> this.getDirectly(key));
    }

    private CuratorCache findCuratorCache(String key) {
        for (Map.Entry<String, CuratorCache> entry : this.caches.entrySet()) {
            if (!key.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public String getDirectly(String key) {
        try {
            return new String((byte[])this.client.getData().forPath(key), StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException((Exception)ex);
            return null;
        }
    }

    public List<String> getChildrenKeys(String key) {
        try {
            List result = (List)this.client.getChildren().forPath(key);
            result.sort(Comparator.reverseOrder());
            return result;
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException((Exception)ex);
            return Collections.emptyList();
        }
    }

    public int getNumChildren(String key) {
        try {
            Stat stat = (Stat)this.client.checkExists().forPath(key);
            if (null != stat) {
                return stat.getNumChildren();
            }
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException((Exception)ex);
        }
        return 0;
    }

    public boolean isExisted(String key) {
        try {
            return null != this.client.checkExists().forPath(key);
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException((Exception)ex);
            return false;
        }
    }

    public void persist(String key, String value) {
        try {
            if (!this.isExisted(key)) {
                ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
            } else {
                this.update(key, value);
            }
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException((Exception)ex);
        }
    }

    public void update(String key, String value) {
        try {
            TransactionOp transactionOp = this.client.transactionOp();
            this.client.transaction().forOperations(new CuratorOp[]{(CuratorOp)transactionOp.check().forPath(key), (CuratorOp)transactionOp.setData().forPath(key, value.getBytes(StandardCharsets.UTF_8))});
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException((Exception)ex);
        }
    }

    public void persistEphemeral(String key, String value) {
        try {
            if (this.isExisted(key)) {
                this.client.delete().deletingChildrenIfNeeded().forPath(key);
            }
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException((Exception)ex);
        }
    }

    public String persistSequential(String key, String value) {
        try {
            return (String)((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException((Exception)ex);
            return null;
        }
    }

    public void persistEphemeralSequential(String key) {
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(key);
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException((Exception)ex);
        }
    }

    public void remove(String key) {
        try {
            this.client.delete().deletingChildrenIfNeeded().forPath(key);
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException((Exception)ex);
        }
    }

    public long getRegistryCenterTime(String key) {
        long result = 0L;
        try {
            this.persist(key, "");
            result = ((Stat)this.client.checkExists().forPath(key)).getMtime();
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException((Exception)ex);
        }
        Preconditions.checkState((0L != result ? 1 : 0) != 0, (Object)"Cannot get registry center time.");
        return result;
    }

    public Object getRawClient() {
        return this.client;
    }

    public void addConnectionStateChangedEventListener(ConnectionStateChangedEventListener listener) {
        ZookeeperRegistryCenter coordinatorRegistryCenter = this;
        this.client.getConnectionStateListenable().addListener((client, newState) -> {
            ConnectionStateChangedEventListener.State state;
            switch (newState) {
                case CONNECTED: {
                    state = ConnectionStateChangedEventListener.State.CONNECTED;
                    break;
                }
                case LOST: 
                case SUSPENDED: {
                    state = ConnectionStateChangedEventListener.State.UNAVAILABLE;
                    break;
                }
                case RECONNECTED: {
                    state = ConnectionStateChangedEventListener.State.RECONNECTED;
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal registry center connection state: " + newState);
                }
            }
            listener.onStateChanged(coordinatorRegistryCenter, state);
        });
    }

    public void executeInTransaction(List<TransactionOperation> transactionOperations) throws Exception {
        this.client.transaction().forOperations(this.toCuratorOps(transactionOperations));
    }

    private List<CuratorOp> toCuratorOps(List<TransactionOperation> transactionOperations) {
        ArrayList<CuratorOp> result = new ArrayList<CuratorOp>(transactionOperations.size());
        TransactionOp transactionOp = this.client.transactionOp();
        for (TransactionOperation each : transactionOperations) {
            result.add(this.toCuratorOp(each, transactionOp));
        }
        return result;
    }

    private CuratorOp toCuratorOp(TransactionOperation each, TransactionOp transactionOp) {
        try {
            switch (each.getType()) {
                case CHECK_EXISTS: {
                    return (CuratorOp)transactionOp.check().forPath(each.getKey());
                }
                case ADD: {
                    return (CuratorOp)transactionOp.create().forPath(each.getKey(), each.getValue().getBytes(StandardCharsets.UTF_8));
                }
                case UPDATE: {
                    return (CuratorOp)transactionOp.setData().forPath(each.getKey(), each.getValue().getBytes(StandardCharsets.UTF_8));
                }
                case DELETE: {
                    return (CuratorOp)transactionOp.delete().forPath(each.getKey());
                }
            }
            throw new UnsupportedOperationException(each.toString());
        }
        catch (Exception ex) {
            throw new RegException(ex);
        }
    }

    public void addCacheData(String cachePath) {
        CuratorCache cache = CuratorCache.build((CuratorFramework)this.client, (String)cachePath, (CuratorCache.Options[])new CuratorCache.Options[0]);
        try {
            cache.start();
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException((Exception)ex);
        }
        this.caches.put(cachePath + "/", cache);
    }

    public void evictCacheData(String cachePath) {
        CuratorCache cache = this.caches.remove(cachePath + "/");
        if (null != cache) {
            cache.close();
        }
    }

    public Object getRawCache(String cachePath) {
        return this.caches.get(cachePath + "/");
    }

    public void executeInLeader(String key, LeaderExecutionCallback callback) {
        try (LeaderLatch latch = new LeaderLatch(this.client, key);){
            latch.start();
            latch.await();
            callback.execute();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void watch(String key, DataChangedEventListener listener, Executor executor) {
        CuratorCache cache = this.caches.get(key + "/");
        CuratorCacheListener cacheListener = (curatorType, oldData, newData) -> {
            String path;
            if (null == newData && null == oldData) {
                return;
            }
            DataChangedEvent.Type type = this.getTypeFromCuratorType(curatorType);
            String string = path = DataChangedEvent.Type.DELETED == type ? oldData.getPath() : newData.getPath();
            if (path.isEmpty() || DataChangedEvent.Type.IGNORED == type) {
                return;
            }
            byte[] data = DataChangedEvent.Type.DELETED == type ? oldData.getData() : newData.getData();
            listener.onChange(new DataChangedEvent(type, path, null == data ? "" : new String(data, StandardCharsets.UTF_8)));
        };
        if (executor != null) {
            cache.listenable().addListener((Object)cacheListener, executor);
        } else {
            cache.listenable().addListener((Object)cacheListener);
        }
    }

    private DataChangedEvent.Type getTypeFromCuratorType(CuratorCacheListener.Type curatorType) {
        switch (curatorType) {
            case NODE_CREATED: {
                return DataChangedEvent.Type.ADDED;
            }
            case NODE_DELETED: {
                return DataChangedEvent.Type.DELETED;
            }
            case NODE_CHANGED: {
                return DataChangedEvent.Type.UPDATED;
            }
        }
        return DataChangedEvent.Type.IGNORED;
    }

    private void handleException(Exception ex) {
        if (!(ex instanceof InterruptedException)) {
            throw new RegException(ex);
        }
        Thread.currentThread().interrupt();
    }

    @Generated
    protected ZookeeperConfiguration getZkConfig() {
        return this.zkConfig;
    }

    @Generated
    public CuratorFramework getClient() {
        return this.client;
    }
}

