/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.util;

import org.springframework.data.util.ProxyUtils;
import org.springframework.util.ClassUtils;

class HibernateProxyDetector
implements ProxyUtils.ProxyDetector {
    private static final Class<?> HIBERNATE_PROXY = HibernateProxyDetector.loadHibernateProxyType();

    HibernateProxyDetector() {
    }

    public Class<?> getUserType(Class<?> type) {
        Class<?> result;
        if (HIBERNATE_PROXY == null) {
            return type;
        }
        if (HIBERNATE_PROXY.isAssignableFrom(type) && (result = type.getSuperclass()) != null && !Object.class.equals(result)) {
            return result;
        }
        return type;
    }

    private static final Class<?> loadHibernateProxyType() {
        try {
            return ClassUtils.forName((String)"org.hibernate.proxy.HibernateProxy", (ClassLoader)HibernateProxyDetector.class.getClassLoader());
        }
        catch (ClassNotFoundException o_O) {
            return null;
        }
    }
}

