/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.AttributeUtils;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.Modifiers;
import org.aspectj.apache.bcel.classfile.Node;
import org.aspectj.apache.bcel.classfile.Signature;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeAnnos;

public abstract class FieldOrMethod
extends Modifiers
implements Node {
    protected int nameIndex;
    protected int signatureIndex;
    protected Attribute[] attributes;
    protected ConstantPool cpool;
    private String name;
    private String signature;
    private AnnotationGen[] annotations;
    private String signatureAttributeString = null;
    private boolean searchedForSignatureAttribute = false;

    protected FieldOrMethod() {
    }

    protected FieldOrMethod(FieldOrMethod fieldOrMethod) {
        this(fieldOrMethod.getModifiers(), fieldOrMethod.getNameIndex(), fieldOrMethod.getSignatureIndex(), fieldOrMethod.getAttributes(), fieldOrMethod.getConstantPool());
    }

    protected FieldOrMethod(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), null, constantPool);
        this.attributes = AttributeUtils.readAttributes(dataInputStream, constantPool);
    }

    protected FieldOrMethod(int n, int n2, int n3, Attribute[] attributeArray, ConstantPool constantPool) {
        this.modifiers = n;
        this.nameIndex = n2;
        this.signatureIndex = n3;
        this.cpool = constantPool;
        this.attributes = attributeArray;
    }

    public void setAttributes(Attribute[] attributeArray) {
        this.attributes = attributeArray;
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.modifiers);
        dataOutputStream.writeShort(this.nameIndex);
        dataOutputStream.writeShort(this.signatureIndex);
        AttributeUtils.writeAttributes(this.attributes, dataOutputStream);
    }

    public final Attribute[] getAttributes() {
        return this.attributes;
    }

    public final ConstantPool getConstantPool() {
        return this.cpool;
    }

    public final int getNameIndex() {
        return this.nameIndex;
    }

    public final int getSignatureIndex() {
        return this.signatureIndex;
    }

    public final String getName() {
        if (this.name == null) {
            ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpool.getConstant(this.nameIndex, (byte)1);
            this.name = constantUtf8.getValue();
        }
        return this.name;
    }

    public final String getSignature() {
        if (this.signature == null) {
            ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpool.getConstant(this.signatureIndex, (byte)1);
            this.signature = constantUtf8.getValue();
        }
        return this.signature;
    }

    public final String getDeclaredSignature() {
        if (this.getGenericSignature() != null) {
            return this.getGenericSignature();
        }
        return this.getSignature();
    }

    public AnnotationGen[] getAnnotations() {
        if (this.annotations == null) {
            ArrayList<AnnotationGen> arrayList = new ArrayList<AnnotationGen>();
            for (int i = 0; i < this.attributes.length; ++i) {
                Attribute attribute = this.attributes[i];
                if (!(attribute instanceof RuntimeAnnos)) continue;
                RuntimeAnnos runtimeAnnos = (RuntimeAnnos)attribute;
                arrayList.addAll(runtimeAnnos.getAnnotations());
            }
            this.annotations = arrayList.size() == 0 ? AnnotationGen.NO_ANNOTATIONS : arrayList.toArray(new AnnotationGen[0]);
        }
        return this.annotations;
    }

    public final String getGenericSignature() {
        if (!this.searchedForSignatureAttribute) {
            Signature signature = AttributeUtils.getSignatureAttribute(this.attributes);
            this.signatureAttributeString = signature == null ? null : signature.getSignature();
            this.searchedForSignatureAttribute = true;
        }
        return this.signatureAttributeString;
    }
}

