/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.Constant;

public final class ConstantMethodType
extends Constant {
    private int descriptorIndex;

    ConstantMethodType(DataInputStream dataInputStream) throws IOException {
        this(dataInputStream.readUnsignedShort());
    }

    public ConstantMethodType(int n) {
        super((byte)16);
        this.descriptorIndex = n;
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.tag);
        dataOutputStream.writeShort(this.descriptorIndex);
    }

    public final int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    @Override
    public final String toString() {
        return super.toString() + "(descriptorIndex=" + this.descriptorIndex + ")";
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitConstantMethodType(this);
    }
}

