/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice.jdbc;

import org.apache.openjpa.jdbc.kernel.JDBCFetchConfigurationImpl;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.FetchConfigurationImpl;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.UserException;

public class TargetFetchConfiguration
extends JDBCFetchConfigurationImpl
implements FetchConfiguration {
    private static final long serialVersionUID = 1L;
    boolean _explicitTarget = false;

    public TargetFetchConfiguration() {
    }

    @Override
    public void setHint(String key, Object value) {
        super.setHint(key, value);
        this._explicitTarget = "openjpa.hint.slice.Target".equals(key);
    }

    @Override
    public void setHint(String key, Object value, Object original) {
        super.setHint(key, value, original);
        this._explicitTarget = "openjpa.hint.slice.Target".equals(key);
    }

    public void setTargets(String[] targets) {
        super.setHint("openjpa.hint.slice.Target", targets);
        this._explicitTarget = false;
    }

    public boolean isExplicitTarget() {
        return this._explicitTarget;
    }

    String[] toSliceNames(Object o, boolean user) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return new String[]{o.toString()};
        }
        if (o instanceof String[]) {
            if (((String[])o).length == 0) {
                throw new InternalException("Hint values " + o + " are wrong type " + o.getClass());
            }
            return (String[])o;
        }
        throw new InternalException("Hint values " + o + " are wrong type " + o.getClass());
    }

    void assertTargets(String[] targets, boolean user) {
        if (targets != null && targets.length == 0 && user) {
            throw new UserException("Hint values " + targets + " are empty");
        }
    }

    @Override
    protected TargetFetchConfiguration newInstance(FetchConfigurationImpl.ConfigurationState state) {
        JDBCFetchConfigurationImpl.JDBCConfigurationState jstate = state == null ? null : this._state;
        return new TargetFetchConfiguration(state, jstate);
    }

    protected TargetFetchConfiguration(FetchConfigurationImpl.ConfigurationState state, JDBCFetchConfigurationImpl.JDBCConfigurationState jstate) {
        super(state, jstate);
    }
}

