/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.sql.SQLException;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.DiscriminatorMappingInfo;
import org.apache.openjpa.jdbc.meta.strats.AbstractDiscriminatorStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.MetaDataException;

public class SubclassJoinDiscriminatorStrategy
extends AbstractDiscriminatorStrategy {
    private static final long serialVersionUID = 1L;
    public static final String ALIAS = "subclass-join";
    private static final Localizer _loc = Localizer.forPackage(SubclassJoinDiscriminatorStrategy.class);

    @Override
    public String getAlias() {
        return ALIAS;
    }

    @Override
    public void map(boolean adapt) {
        ClassMapping cls = this.disc.getClassMapping();
        if (cls.getJoinablePCSuperclassMapping() != null || cls.getEmbeddingMetaData() != null) {
            throw new MetaDataException(_loc.get("not-base-disc", cls));
        }
        DiscriminatorMappingInfo info = this.disc.getMappingInfo();
        info.assertNoSchemaComponents(this.disc, true);
        DBDictionary dict = cls.getMappingRepository().getDBDictionary();
        if (dict.joinSyntax == 1) {
            throw new MetaDataException(_loc.get("outer-join-support", cls));
        }
    }

    @Override
    public boolean select(Select sel, ClassMapping mapping) {
        ClassMapping[] subs;
        if (this.isFinal) {
            return false;
        }
        boolean seld = false;
        if (mapping.getPrimaryKeyColumns().length > 0 && mapping.getJoinablePCSuperclassMapping() != null) {
            sel.select(mapping.getPrimaryKeyColumns()[0]);
            seld = true;
        }
        if ((subs = mapping.getJoinablePCSubclassMappings()).length == 0) {
            return seld;
        }
        for (int i = 0; i < subs.length; ++i) {
            Column[] pks;
            if (subs[i].getJoinablePCSuperclassMapping() == null || (pks = subs[i].getPrimaryKeyColumns()).length <= 0) continue;
            sel.select(pks[0], subs[i].joinSuperclass(sel.newJoins(), true));
            seld = true;
        }
        return seld;
    }

    @Override
    public Class getClass(JDBCStore store, ClassMapping base, Result res) throws SQLException, ClassNotFoundException {
        if (this.isFinal) {
            return base.getDescribedType();
        }
        ClassMapping[] subs = base.getJoinablePCSubclassMappings();
        Class<?> derived = base.getDescribedType();
        for (int i = 0; i < subs.length; ++i) {
            Column[] pks = subs[i].getPrimaryKeyColumns();
            if (pks.length == 0 || !derived.isAssignableFrom(subs[i].getDescribedType()) || !res.contains(pks[0]) || res.getObject((Object)pks[0], -1, null) == null) continue;
            derived = subs[i].getDescribedType();
        }
        return derived;
    }

    @Override
    public boolean hasClassConditions(ClassMapping base, boolean subclasses) {
        if (this.isFinal || subclasses) {
            return false;
        }
        ClassMapping[] subs = base.getJoinablePCSubclassMappings();
        return subs.length != 0;
    }

    @Override
    public SQLBuffer getClassConditions(Select sel, Joins joins, ClassMapping base, boolean subclasses) {
        ClassMapping[] subs = base.getJoinablePCSubclassMappings();
        SQLBuffer buf = null;
        for (int i = 0; i < subs.length; ++i) {
            Column[] pks = subs[i].getPrimaryKeyColumns();
            if (pks.length == 0) continue;
            if (buf == null) {
                buf = new SQLBuffer(sel.getConfiguration().getDBDictionaryInstance());
                sel.getColumnAlias(base.getPrimaryKeyColumns()[0], joins);
            } else {
                buf.append(" AND ");
            }
            buf.append(sel.getColumnAlias(pks[0], joins)).append(" IS NULL");
        }
        return buf;
    }
}

