/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.restful.wrapper;

import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class QueryParameterMap
extends AbstractMap<String, List<String>> {
    private final Map<String, List<String>> queryMap;

    public QueryParameterMap() {
        this.queryMap = new LinkedHashMap<String, List<String>>();
    }

    public QueryParameterMap(Map<String, List<String>> map) {
        this.queryMap = new LinkedHashMap<String, List<String>>(map);
    }

    public List<String> get(String parameterName) {
        return this.queryMap.get(parameterName);
    }

    public String getFirst(String parameterName) {
        String firstValue = null;
        List<String> values = this.queryMap.get(parameterName);
        if (values != null && !values.isEmpty()) {
            firstValue = values.get(0);
        }
        return firstValue;
    }

    @Override
    public boolean isEmpty() {
        return this.queryMap.isEmpty();
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.queryMap.entrySet();
    }

    public void add(String parameterName, String value) {
        List<String> values = this.queryMap.get(parameterName);
        if (null == values) {
            values = new LinkedList<String>();
        }
        values.add(value);
        this.put(parameterName, values);
    }

    @Override
    public List<String> put(String parameterName, List<String> value) {
        return this.queryMap.put(parameterName, value);
    }

    public Map<String, String> toSingleValueMap() {
        return this.queryMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)((List)entry.getValue()).get(0)));
    }
}

