/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.state.failover;

import com.google.common.base.Strings;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.cloud.config.pojo.CloudJobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.config.job.CloudJobConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.context.JobContext;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.env.BootstrapEnvironment;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.failover.FailoverNode;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.failover.FailoverTaskInfo;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.running.RunningService;
import org.apache.shardingsphere.elasticjob.infra.context.ExecutionType;
import org.apache.shardingsphere.elasticjob.infra.context.TaskContext;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FailoverService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FailoverService.class);
    private final BootstrapEnvironment env = BootstrapEnvironment.getINSTANCE();
    private final CoordinatorRegistryCenter regCenter;
    private final CloudJobConfigurationService configService;
    private final RunningService runningService;

    public FailoverService(CoordinatorRegistryCenter regCenter) {
        this.regCenter = regCenter;
        this.configService = new CloudJobConfigurationService(regCenter);
        this.runningService = new RunningService(regCenter);
    }

    public void add(TaskContext taskContext) {
        if (this.regCenter.getNumChildren("/state/failover") > this.env.getFrameworkConfiguration().getJobStateQueueSize()) {
            log.warn("Cannot add job, caused by read state queue size is larger than {}.", (Object)this.env.getFrameworkConfiguration().getJobStateQueueSize());
            return;
        }
        String failoverTaskNodePath = FailoverNode.getFailoverTaskNodePath(taskContext.getMetaInfo().toString());
        if (!this.regCenter.isExisted(failoverTaskNodePath) && !this.runningService.isTaskRunning(taskContext.getMetaInfo())) {
            this.regCenter.persist(failoverTaskNodePath, taskContext.getId());
        }
    }

    public Collection<JobContext> getAllEligibleJobContexts() {
        if (!this.regCenter.isExisted("/state/failover")) {
            return Collections.emptyList();
        }
        List jobNames = this.regCenter.getChildrenKeys("/state/failover");
        ArrayList<JobContext> result = new ArrayList<JobContext>(jobNames.size());
        HashSet<HashCode> assignedTasks = new HashSet<HashCode>(jobNames.size() * 10, 1.0f);
        for (String each : jobNames) {
            List taskIdList = this.regCenter.getChildrenKeys(FailoverNode.getFailoverJobNodePath(each));
            if (taskIdList.isEmpty()) {
                this.regCenter.remove(FailoverNode.getFailoverJobNodePath(each));
                continue;
            }
            Optional<CloudJobConfigurationPOJO> cloudJobConfig = this.configService.load(each);
            if (!cloudJobConfig.isPresent()) {
                this.regCenter.remove(FailoverNode.getFailoverJobNodePath(each));
                continue;
            }
            List<Integer> assignedShardingItems = this.getAssignedShardingItems(each, taskIdList, assignedTasks);
            if (assignedShardingItems.isEmpty()) continue;
            result.add(new JobContext(cloudJobConfig.get().toCloudJobConfiguration(), assignedShardingItems, ExecutionType.FAILOVER));
        }
        return result;
    }

    private List<Integer> getAssignedShardingItems(String jobName, List<String> taskIdList, Set<HashCode> assignedTasks) {
        ArrayList<Integer> result = new ArrayList<Integer>(taskIdList.size());
        for (String each : taskIdList) {
            TaskContext.MetaInfo metaInfo = TaskContext.MetaInfo.from((String)each);
            if (!assignedTasks.add(Hashing.sha256().newHasher().putString((CharSequence)jobName, StandardCharsets.UTF_8).putInt(((Integer)metaInfo.getShardingItems().get(0)).intValue()).hash()) || this.runningService.isTaskRunning(metaInfo)) continue;
            result.add((Integer)metaInfo.getShardingItems().get(0));
        }
        return result;
    }

    public void remove(Collection<TaskContext.MetaInfo> metaInfoList) {
        for (TaskContext.MetaInfo each : metaInfoList) {
            this.regCenter.remove(FailoverNode.getFailoverTaskNodePath(each.toString()));
        }
    }

    public Optional<String> getTaskId(TaskContext.MetaInfo metaInfo) {
        String failoverTaskNodePath = FailoverNode.getFailoverTaskNodePath(metaInfo.toString());
        return this.regCenter.isExisted(failoverTaskNodePath) ? Optional.of(this.regCenter.get(failoverTaskNodePath)) : Optional.empty();
    }

    public Map<String, Collection<FailoverTaskInfo>> getAllFailoverTasks() {
        if (!this.regCenter.isExisted("/state/failover")) {
            return Collections.emptyMap();
        }
        List jobNames = this.regCenter.getChildrenKeys("/state/failover");
        HashMap<String, Collection<FailoverTaskInfo>> result = new HashMap<String, Collection<FailoverTaskInfo>>(jobNames.size(), 1.0f);
        for (String each : jobNames) {
            Collection<FailoverTaskInfo> failoverTasks = this.getFailoverTasks(each);
            if (failoverTasks.isEmpty()) continue;
            result.put(each, failoverTasks);
        }
        return result;
    }

    private Collection<FailoverTaskInfo> getFailoverTasks(String jobName) {
        List failOverTasks = this.regCenter.getChildrenKeys(FailoverNode.getFailoverJobNodePath(jobName));
        ArrayList<FailoverTaskInfo> result = new ArrayList<FailoverTaskInfo>(failOverTasks.size());
        for (String each : failOverTasks) {
            String originalTaskId = this.regCenter.get(FailoverNode.getFailoverTaskNodePath(each));
            if (Strings.isNullOrEmpty((String)originalTaskId)) continue;
            result.add(new FailoverTaskInfo(TaskContext.MetaInfo.from((String)each), originalTaskId));
        }
        return result;
    }
}

