/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.state.disable.app;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.shardingsphere.elasticjob.cloud.config.pojo.CloudJobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.config.job.CloudJobConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.producer.ProducerManager;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class CloudAppDisableListener
implements CuratorCacheListener {
    private final CoordinatorRegistryCenter regCenter;
    private final ProducerManager producerManager;
    private final CloudJobConfigurationService jobConfigService;

    public CloudAppDisableListener(CoordinatorRegistryCenter regCenter, ProducerManager producerManager) {
        this.regCenter = regCenter;
        this.producerManager = producerManager;
        this.jobConfigService = new CloudJobConfigurationService(regCenter);
    }

    public void event(CuratorCacheListener.Type type, ChildData oldData, ChildData data) {
        String appName;
        String path;
        String string = path = CuratorCacheListener.Type.NODE_DELETED == type ? oldData.getPath() : data.getPath();
        if (CuratorCacheListener.Type.NODE_CREATED == type && this.isAppDisableNode(path)) {
            String appName2 = path.substring("/state/disable/app".length() + 1);
            if (Objects.nonNull(appName2)) {
                this.disableApp(appName2);
            }
        } else if (CuratorCacheListener.Type.NODE_DELETED == type && this.isAppDisableNode(path) && Objects.nonNull(appName = path.substring("/state/disable/app".length() + 1))) {
            this.enableApp(appName);
        }
    }

    private boolean isAppDisableNode(String path) {
        return path.startsWith("/state/disable/app") && path.length() > "/state/disable/app".length();
    }

    public void start() {
        this.getCache().listenable().addListener((Object)this, (Executor)Executors.newSingleThreadExecutor());
    }

    public void stop() {
        this.getCache().listenable().removeListener((Object)this);
    }

    private CuratorCache getCache() {
        CuratorCache result = (CuratorCache)this.regCenter.getRawCache("/state/disable/app");
        if (null != result) {
            return result;
        }
        this.regCenter.addCacheData("/state/disable/app");
        return (CuratorCache)this.regCenter.getRawCache("/state/disable/app");
    }

    private void disableApp(String appName) {
        for (CloudJobConfigurationPOJO each : this.jobConfigService.loadAll()) {
            if (!appName.equals(each.getAppName())) continue;
            this.producerManager.unschedule(each.getJobName());
        }
    }

    private void enableApp(String appName) {
        for (CloudJobConfigurationPOJO each : this.jobConfigService.loadAll()) {
            if (!appName.equals(each.getAppName())) continue;
            this.producerManager.reschedule(each.getJobName());
        }
    }
}

