/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.context;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.cloud.config.CloudJobConfiguration;
import org.apache.shardingsphere.elasticjob.infra.context.ExecutionType;

public final class JobContext {
    private final CloudJobConfiguration cloudJobConfig;
    private final List<Integer> assignedShardingItems;
    private final ExecutionType type;

    public static JobContext from(CloudJobConfiguration cloudJobConfig, ExecutionType type) {
        int shardingTotalCount = cloudJobConfig.getJobConfig().getShardingTotalCount();
        ArrayList<Integer> shardingItems = new ArrayList<Integer>(shardingTotalCount);
        for (int i = 0; i < shardingTotalCount; ++i) {
            shardingItems.add(i);
        }
        return new JobContext(cloudJobConfig, shardingItems, type);
    }

    @Generated
    public JobContext(CloudJobConfiguration cloudJobConfig, List<Integer> assignedShardingItems, ExecutionType type) {
        this.cloudJobConfig = cloudJobConfig;
        this.assignedShardingItems = assignedShardingItems;
        this.type = type;
    }

    @Generated
    public CloudJobConfiguration getCloudJobConfig() {
        return this.cloudJobConfig;
    }

    @Generated
    public List<Integer> getAssignedShardingItems() {
        return this.assignedShardingItems;
    }

    @Generated
    public ExecutionType getType() {
        return this.type;
    }
}

