/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.samples;

import com.netflix.fenzo.SchedulingResult;
import com.netflix.fenzo.TaskAssignmentResult;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskScheduler;
import com.netflix.fenzo.VMAssignmentResult;
import com.netflix.fenzo.VirtualMachineLease;
import com.netflix.fenzo.functions.Action1;
import com.netflix.fenzo.functions.Func1;
import com.netflix.fenzo.plugins.VMLeaseObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.mesos.MesosSchedulerDriver;
import org.apache.mesos.Protos;
import org.apache.mesos.Scheduler;
import org.apache.mesos.SchedulerDriver;

public class SampleFramework {
    private final BlockingQueue<TaskRequest> taskQueue;
    private final BlockingQueue<VirtualMachineLease> leasesQueue;
    private final Map<String, String> launchedTasks;
    private final TaskScheduler scheduler;
    private final MesosSchedulerDriver mesosSchedulerDriver;
    private final AtomicReference<MesosSchedulerDriver> ref = new AtomicReference();
    private final Map<String, TaskRequest> pendingTasksMap = new HashMap<String, TaskRequest>();
    private final Action1<String> onTaskComplete;
    private final Func1<String, String> taskCmdGetter;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    public SampleFramework(BlockingQueue<TaskRequest> taskQueue, String mesosMaster, Action1<String> onTaskComplete, Func1<String, String> taskCmdGetter) {
        this.taskQueue = taskQueue;
        this.leasesQueue = new LinkedBlockingQueue<VirtualMachineLease>();
        this.onTaskComplete = onTaskComplete;
        this.taskCmdGetter = taskCmdGetter;
        this.launchedTasks = new HashMap<String, String>();
        this.scheduler = new TaskScheduler.Builder().withLeaseOfferExpirySecs(1000000000L).withLeaseRejectAction(new Action1<VirtualMachineLease>(){

            @Override
            public void call(VirtualMachineLease lease) {
                System.out.println("Declining offer on " + lease.hostname());
                ((MesosSchedulerDriver)SampleFramework.this.ref.get()).declineOffer(lease.getOffer().getId());
            }
        }).build();
        Protos.FrameworkInfo framework = Protos.FrameworkInfo.newBuilder().setName("Sample Fenzo Framework").setUser("").build();
        MesosScheduler mesosScheduler = new MesosScheduler();
        this.mesosSchedulerDriver = new MesosSchedulerDriver((Scheduler)mesosScheduler, framework, mesosMaster);
        this.ref.set(this.mesosSchedulerDriver);
        new Thread(){

            @Override
            public void run() {
                SampleFramework.this.mesosSchedulerDriver.run();
            }
        }.start();
    }

    public void shutdown() {
        System.out.println("Stopping down mesos driver");
        Protos.Status status = this.mesosSchedulerDriver.stop();
        this.isShutdown.set(true);
    }

    public void start() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SampleFramework.this.runAll();
            }
        }).start();
    }

    void runAll() {
        System.out.println("Running all");
        ArrayList<VirtualMachineLease> newLeases = new ArrayList<VirtualMachineLease>();
        while (!this.isShutdown.get()) {
            newLeases.clear();
            ArrayList<TaskRequest> newTaskRequests = new ArrayList<TaskRequest>();
            System.out.println("#Pending tasks: " + this.pendingTasksMap.size());
            TaskRequest taskRequest = null;
            try {
                taskRequest = this.pendingTasksMap.size() == 0 ? this.taskQueue.poll(5L, TimeUnit.SECONDS) : this.taskQueue.poll(1L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                System.err.println("Error polling task queue: " + ie.getMessage());
            }
            if (taskRequest != null) {
                this.taskQueue.drainTo(newTaskRequests);
                newTaskRequests.add(0, taskRequest);
                for (TaskRequest request : newTaskRequests) {
                    this.pendingTasksMap.put(request.getId(), request);
                }
            }
            this.leasesQueue.drainTo(newLeases);
            SchedulingResult schedulingResult = this.scheduler.scheduleOnce(new ArrayList<TaskRequest>(this.pendingTasksMap.values()), newLeases);
            System.out.println("result=" + schedulingResult);
            Map<String, VMAssignmentResult> resultMap = schedulingResult.getResultMap();
            if (!resultMap.isEmpty()) {
                for (VMAssignmentResult result : resultMap.values()) {
                    List<VirtualMachineLease> leasesUsed = result.getLeasesUsed();
                    ArrayList<Protos.TaskInfo> taskInfos = new ArrayList<Protos.TaskInfo>();
                    StringBuilder stringBuilder = new StringBuilder("Launching on VM " + leasesUsed.get(0).hostname() + " tasks ");
                    Protos.SlaveID slaveId = leasesUsed.get(0).getOffer().getSlaveId();
                    for (TaskAssignmentResult t : result.getTasksAssigned()) {
                        stringBuilder.append(t.getTaskId()).append(", ");
                        taskInfos.add(SampleFramework.getTaskInfo(slaveId, t.getTaskId(), this.taskCmdGetter.call(t.getTaskId())));
                        this.pendingTasksMap.remove(t.getTaskId());
                        this.launchedTasks.put(t.getTaskId(), leasesUsed.get(0).hostname());
                        this.scheduler.getTaskAssigner().call(t.getRequest(), leasesUsed.get(0).hostname());
                    }
                    ArrayList<Protos.OfferID> offerIDs = new ArrayList<Protos.OfferID>();
                    for (VirtualMachineLease l : leasesUsed) {
                        offerIDs.add(l.getOffer().getId());
                    }
                    System.out.println(stringBuilder.toString());
                    this.mesosSchedulerDriver.launchTasks(offerIDs, taskInfos);
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    static Protos.TaskInfo getTaskInfo(Protos.SlaveID slaveID, String taskId, String cmd) {
        Protos.TaskID pTaskId = Protos.TaskID.newBuilder().setValue(taskId).build();
        return Protos.TaskInfo.newBuilder().setName("task " + pTaskId.getValue()).setTaskId(pTaskId).setSlaveId(slaveID).addResources(Protos.Resource.newBuilder().setName("cpus").setType(Protos.Value.Type.SCALAR).setScalar(Protos.Value.Scalar.newBuilder().setValue(1.0))).addResources(Protos.Resource.newBuilder().setName("mem").setType(Protos.Value.Type.SCALAR).setScalar(Protos.Value.Scalar.newBuilder().setValue(128.0))).setCommand(Protos.CommandInfo.newBuilder().setValue(cmd).build()).build();
    }

    public class MesosScheduler
    implements Scheduler {
        public void registered(SchedulerDriver driver, Protos.FrameworkID frameworkId, Protos.MasterInfo masterInfo) {
            System.out.println("Registered! ID = " + frameworkId.getValue());
            SampleFramework.this.scheduler.expireAllLeases();
        }

        public void reregistered(SchedulerDriver driver, Protos.MasterInfo masterInfo) {
            System.out.println("Re-registered " + masterInfo.getId());
            SampleFramework.this.scheduler.expireAllLeases();
        }

        public void resourceOffers(SchedulerDriver driver, List<Protos.Offer> offers) {
            for (Protos.Offer offer : offers) {
                System.out.println("Adding offer " + offer.getId() + " from host " + offer.getHostname());
                SampleFramework.this.leasesQueue.offer(new VMLeaseObject(offer));
            }
        }

        public void offerRescinded(SchedulerDriver driver, Protos.OfferID offerId) {
            SampleFramework.this.scheduler.expireLease(offerId.getValue());
        }

        public void statusUpdate(SchedulerDriver driver, Protos.TaskStatus status) {
            System.out.println("Task Update: " + status.getTaskId().getValue() + " in state " + status.getState());
            switch (status.getState()) {
                case TASK_FAILED: 
                case TASK_LOST: 
                case TASK_FINISHED: {
                    SampleFramework.this.onTaskComplete.call(status.getTaskId().getValue());
                    SampleFramework.this.scheduler.getTaskUnAssigner().call(status.getTaskId().getValue(), (String)SampleFramework.this.launchedTasks.get(status.getTaskId().getValue()));
                }
            }
        }

        public void frameworkMessage(SchedulerDriver driver, Protos.ExecutorID executorId, Protos.SlaveID slaveId, byte[] data) {
        }

        public void disconnected(SchedulerDriver driver) {
        }

        public void slaveLost(SchedulerDriver driver, Protos.SlaveID slaveId) {
            SampleFramework.this.scheduler.expireAllLeasesByVMId(slaveId.getValue());
        }

        public void executorLost(SchedulerDriver driver, Protos.ExecutorID executorId, Protos.SlaveID slaveId, int status) {
            System.out.println("Executor " + executorId.getValue() + " lost, status=" + status);
        }

        public void error(SchedulerDriver driver, String message) {
        }
    }
}

