/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.queues.tiered;

import com.netflix.fenzo.sla.ResAllocs;
import com.netflix.fenzo.sla.ResAllocsUtil;
import java.util.HashMap;
import java.util.Map;

class TierSla {
    static final double eps = 0.001;
    private ResAllocs tierCapacity;
    private final Map<String, ResAllocs> allocsMap = new HashMap<String, ResAllocs>();
    private double totalCpu = 0.0;
    private double totalMem = 0.0;
    private double totalNetwork = 0.0;
    private double totalDisk = 0.0;

    TierSla() {
    }

    void setTierCapacity(ResAllocs tierCapacity) {
        this.tierCapacity = tierCapacity;
    }

    void setAlloc(String bucket, ResAllocs value) {
        ResAllocs prev = this.allocsMap.put(bucket, value);
        if (prev != null) {
            this.subtract(prev);
        }
        this.add(value);
    }

    private void add(ResAllocs value) {
        this.totalCpu += value.getCores();
        this.totalMem += value.getMemory();
        this.totalNetwork += value.getNetworkMbps();
        this.totalDisk += value.getDisk();
    }

    private void subtract(ResAllocs value) {
        this.totalCpu -= value.getCores();
        this.totalMem -= value.getMemory();
        this.totalNetwork -= value.getNetworkMbps();
        this.totalDisk -= value.getDisk();
    }

    public ResAllocs getTierCapacity() {
        return this.tierCapacity;
    }

    ResAllocs getBucketAllocs(String bucketName) {
        return this.allocsMap.computeIfAbsent(bucketName, name -> ResAllocsUtil.emptyOf(bucketName));
    }

    Map<String, ResAllocs> getAllocsMap() {
        return this.allocsMap;
    }

    double evalAllocationShare(String bucket) {
        if (this.allocsMap.isEmpty()) {
            return 1.0;
        }
        ResAllocs resAllocs = this.allocsMap.get(bucket);
        if (resAllocs == null) {
            return this.totalCpu < 1000.0 ? 0.001 : 1.0 / this.totalCpu;
        }
        double val = this.totalCpu < 1.0 ? 0.001 : resAllocs.getCores() / this.totalCpu;
        val = Math.max(val, this.totalMem < 1.0 ? 0.001 : resAllocs.getMemory() / this.totalMem);
        val = Math.max(val, this.totalNetwork < 1.0 ? 0.001 : resAllocs.getNetworkMbps() / this.totalNetwork);
        return Math.max(val, this.totalDisk < 1.0 ? 0.001 : resAllocs.getDisk() / this.totalDisk);
    }
}

