/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.checker;

import java.sql.SQLException;
import java.util.Collection;
import javax.sql.DataSource;
import org.apache.shardingsphere.data.pipeline.core.checker.DialectPipelineDatabaseVariableChecker;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PrepareJobWithTargetTableNotEmptyException;
import org.apache.shardingsphere.data.pipeline.core.importer.ImporterConfiguration;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.sql.PipelinePrepareSQLBuilder;
import org.apache.shardingsphere.infra.database.core.checker.DialectDatabasePrivilegeChecker;
import org.apache.shardingsphere.infra.database.core.checker.PrivilegeCheckType;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.wrapper.SQLWrapperException;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;

public final class PipelineDataSourceCheckEngine {
    private final DatabaseType databaseType;
    private final PipelinePrepareSQLBuilder sqlBuilder;

    public PipelineDataSourceCheckEngine(DatabaseType databaseType) {
        this.databaseType = databaseType;
        this.sqlBuilder = new PipelinePrepareSQLBuilder(databaseType);
    }

    public void checkConnection(Collection<DataSource> dataSources) {
        try {
            for (DataSource each : dataSources) {
                each.getConnection().close();
            }
        }
        catch (SQLException ex) {
            throw new SQLWrapperException(ex);
        }
    }

    public void checkSourceDataSources(Collection<DataSource> dataSources) {
        this.checkConnection(dataSources);
        DatabaseTypedSPILoader.findService(DialectDatabasePrivilegeChecker.class, (DatabaseType)this.databaseType).ifPresent(optional -> dataSources.forEach(each -> optional.check(each, PrivilegeCheckType.PIPELINE)));
        DatabaseTypedSPILoader.findService(DialectPipelineDatabaseVariableChecker.class, (DatabaseType)this.databaseType).ifPresent(optional -> dataSources.forEach(optional::check));
    }

    public void checkTargetDataSources(Collection<DataSource> dataSources, ImporterConfiguration importerConfig) {
        this.checkConnection(dataSources);
        this.checkEmptyTable(dataSources, importerConfig);
    }

    private void checkEmptyTable(Collection<DataSource> dataSources, ImporterConfiguration importerConfig) {
        try {
            for (DataSource each : dataSources) {
                for (QualifiedTable qualifiedTable : importerConfig.getQualifiedTables()) {
                    ShardingSpherePreconditions.checkState((boolean)this.checkEmptyTable(each, qualifiedTable), () -> new PrepareJobWithTargetTableNotEmptyException(qualifiedTable.getTableName()));
                }
            }
        }
        catch (SQLException ex) {
            throw new SQLWrapperException(ex);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean checkEmptyTable(DataSource dataSource, QualifiedTable qualifiedTable) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

