/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.yaml.swapper;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.shadow.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.YamlShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.datasource.YamlShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.table.YamlShadowTableConfiguration;
import org.apache.shardingsphere.shadow.yaml.swapper.datasource.YamlShadowDataSourceConfigurationSwapper;
import org.apache.shardingsphere.shadow.yaml.swapper.table.YamlShadowTableConfigurationSwapper;

public final class YamlShadowRuleConfigurationSwapper
implements YamlRuleConfigurationSwapper<YamlShadowRuleConfiguration, ShadowRuleConfiguration> {
    private final YamlShadowDataSourceConfigurationSwapper dataSourceConfigSwapper = new YamlShadowDataSourceConfigurationSwapper();
    private final YamlShadowTableConfigurationSwapper tableConfigSwapper = new YamlShadowTableConfigurationSwapper();
    private final YamlAlgorithmConfigurationSwapper algorithmSwapper = new YamlAlgorithmConfigurationSwapper();

    public YamlShadowRuleConfiguration swapToYamlConfiguration(ShadowRuleConfiguration data) {
        YamlShadowRuleConfiguration result = new YamlShadowRuleConfiguration();
        result.getDataSources().putAll(this.swapToYamlDataSources(data.getDataSources()));
        result.getTables().putAll(this.swapToYamlShadowTables(data.getTables()));
        result.getShadowAlgorithms().putAll(this.swapToYamlShadowAlgorithms(data.getShadowAlgorithms()));
        result.setDefaultShadowAlgorithmName(data.getDefaultShadowAlgorithmName());
        this.setTableDefaultShadowDataSource(data.getTables(), data.getDataSources());
        this.setTableDefaultShadowAlgorithm(data.getTables(), data.getDefaultShadowAlgorithmName());
        return result;
    }

    private Map<String, YamlShadowDataSourceConfiguration> swapToYamlDataSources(Collection<ShadowDataSourceConfiguration> dataSources) {
        return dataSources.stream().collect(Collectors.toMap(ShadowDataSourceConfiguration::getName, this.dataSourceConfigSwapper::swapToYamlConfiguration, (a, b) -> b, LinkedHashMap::new));
    }

    private Map<String, YamlShadowTableConfiguration> swapToYamlShadowTables(Map<String, ShadowTableConfiguration> data) {
        return data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.tableConfigSwapper.swapToYamlConfiguration((ShadowTableConfiguration)entry.getValue()), (a, b) -> b, LinkedHashMap::new));
    }

    private Map<String, YamlAlgorithmConfiguration> swapToYamlShadowAlgorithms(Map<String, AlgorithmConfiguration> shadowAlgorithms) {
        return shadowAlgorithms.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.algorithmSwapper.swapToYamlConfiguration((AlgorithmConfiguration)entry.getValue()), (a, b) -> b, LinkedHashMap::new));
    }

    public ShadowRuleConfiguration swapToObject(YamlShadowRuleConfiguration yamlConfig) {
        ShadowRuleConfiguration result = new ShadowRuleConfiguration();
        result.setDataSources(this.swapToDataSources(yamlConfig.getDataSources()));
        result.setTables(this.swapToShadowTables(yamlConfig.getTables()));
        result.setShadowAlgorithms(this.swapToShadowAlgorithms(yamlConfig.getShadowAlgorithms()));
        this.setTableDefaultShadowDataSource(result.getTables(), result.getDataSources());
        this.setTableDefaultShadowAlgorithm(result.getTables(), result.getDefaultShadowAlgorithmName());
        result.setDefaultShadowAlgorithmName(yamlConfig.getDefaultShadowAlgorithmName());
        return result;
    }

    private Collection<ShadowDataSourceConfiguration> swapToDataSources(Map<String, YamlShadowDataSourceConfiguration> dataSources) {
        return dataSources.entrySet().stream().map(entry -> this.swapToDataSource((String)entry.getKey(), (YamlShadowDataSourceConfiguration)entry.getValue())).collect(Collectors.toList());
    }

    private ShadowDataSourceConfiguration swapToDataSource(String name, YamlShadowDataSourceConfiguration yamlConfig) {
        return new ShadowDataSourceConfiguration(name, yamlConfig.getProductionDataSourceName(), yamlConfig.getShadowDataSourceName());
    }

    private Map<String, ShadowTableConfiguration> swapToShadowTables(Map<String, YamlShadowTableConfiguration> tables) {
        return tables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.tableConfigSwapper.swapToObject((YamlShadowTableConfiguration)entry.getValue()), (a, b) -> b, LinkedHashMap::new));
    }

    private Map<String, AlgorithmConfiguration> swapToShadowAlgorithms(Map<String, YamlAlgorithmConfiguration> shadowAlgorithms) {
        return shadowAlgorithms.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.algorithmSwapper.swapToObject((YamlAlgorithmConfiguration)entry.getValue()), (a, b) -> b, LinkedHashMap::new));
    }

    private void setTableDefaultShadowDataSource(Map<String, ShadowTableConfiguration> shadowTables, Collection<ShadowDataSourceConfiguration> shadowDataSources) {
        if (1 == shadowDataSources.size()) {
            for (ShadowTableConfiguration each : shadowTables.values()) {
                if (!each.getDataSourceNames().isEmpty()) continue;
                each.getDataSourceNames().add(shadowDataSources.iterator().next().getName());
            }
        }
    }

    private void setTableDefaultShadowAlgorithm(Map<String, ShadowTableConfiguration> shadowTables, String defaultShadowAlgorithmName) {
        for (ShadowTableConfiguration each : shadowTables.values()) {
            Collection shadowAlgorithmNames = each.getShadowAlgorithmNames();
            if (null == defaultShadowAlgorithmName || !shadowAlgorithmNames.isEmpty()) continue;
            shadowAlgorithmNames.add(defaultShadowAlgorithmName);
        }
    }

    public Class<ShadowRuleConfiguration> getTypeClass() {
        return ShadowRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "SHADOW";
    }

    public int getOrder() {
        return 55;
    }
}

