/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.inline;

import groovy.lang.MissingMethodException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.expr.core.InlineExpressionParserFactory;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;
import org.apache.shardingsphere.sharding.exception.algorithm.MismatchedInlineShardingAlgorithmExpressionAndColumnException;
import org.apache.shardingsphere.sharding.exception.data.NullShardingValueException;

public final class InlineShardingAlgorithm
implements StandardShardingAlgorithm<Comparable<?>> {
    private static final String ALGORITHM_EXPRESSION_KEY = "algorithm-expression";
    private static final String ALLOW_RANGE_QUERY_KEY = "allow-range-query-with-inline-sharding";
    private String algorithmExpression;
    private boolean allowRangeQuery;

    public void init(Properties props) {
        this.algorithmExpression = this.getAlgorithmExpression(props);
        this.allowRangeQuery = this.isAllowRangeQuery(props);
    }

    private String getAlgorithmExpression(Properties props) {
        String expression = props.getProperty(ALGORITHM_EXPRESSION_KEY);
        ShardingSpherePreconditions.checkNotEmpty((String)expression, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "Inline sharding algorithm expression cannot be null or empty", new Object[0]));
        return InlineExpressionParserFactory.newInstance((String)expression.trim()).handlePlaceHolder();
    }

    private boolean isAllowRangeQuery(Properties props) {
        return Boolean.parseBoolean(props.getOrDefault((Object)ALLOW_RANGE_QUERY_KEY, Boolean.FALSE.toString()).toString());
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Comparable<?>> shardingValue) {
        ShardingSpherePreconditions.checkNotNull((Object)shardingValue.getValue(), NullShardingValueException::new);
        String columnName = shardingValue.getColumnName();
        ShardingSpherePreconditions.checkState((boolean)this.algorithmExpression.contains(columnName), () -> new MismatchedInlineShardingAlgorithmExpressionAndColumnException(this.algorithmExpression, columnName));
        try {
            return InlineExpressionParserFactory.newInstance((String)this.algorithmExpression).evaluateWithArgs(Collections.singletonMap(columnName, (Comparable)shardingValue.getValue()));
        }
        catch (MissingMethodException ignored) {
            throw new MismatchedInlineShardingAlgorithmExpressionAndColumnException(this.algorithmExpression, columnName);
        }
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        ShardingSpherePreconditions.checkState((boolean)this.allowRangeQuery, () -> new UnsupportedSQLOperationException(String.format("Since the property of `%s` is false, inline sharding algorithm can not tackle with range query", ALLOW_RANGE_QUERY_KEY)));
        return availableTargetNames;
    }

    public Optional<String> getAlgorithmStructure(String dataNodePrefix, String shardingColumn) {
        return Optional.of(this.algorithmExpression.replaceFirst(dataNodePrefix, "").replaceFirst(shardingColumn, "").replaceAll(" ", ""));
    }

    public String getType() {
        return "INLINE";
    }
}

