/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.expression.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.expression.ExpressionConverter;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.expression.impl.TrimFunctionConverter;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.expression.impl.WindowFunctionConverter;

public final class FunctionConverter {
    public static Optional<SqlNode> convert(FunctionSegment segment) {
        SqlIdentifier functionName = new SqlIdentifier(segment.getFunctionName(), SqlParserPos.ZERO);
        if ("CURRENT_USER".equalsIgnoreCase(functionName.getSimple())) {
            return Optional.of(functionName);
        }
        if ("TRIM".equalsIgnoreCase(functionName.getSimple())) {
            return TrimFunctionConverter.convert(segment);
        }
        if ("OVER".equalsIgnoreCase(functionName.getSimple())) {
            return WindowFunctionConverter.convert(segment);
        }
        LinkedList functions = new LinkedList();
        SqlStdOperatorTable.instance().lookupOperatorOverloads(functionName, null, SqlSyntax.FUNCTION, functions, SqlNameMatchers.withCaseSensitive((boolean)false));
        return Optional.of(functions.isEmpty() ? new SqlBasicCall((SqlOperator)new SqlUnresolvedFunction(functionName, null, null, null, null, SqlFunctionCategory.USER_DEFINED_FUNCTION), FunctionConverter.getFunctionParameters(segment.getParameters()), SqlParserPos.ZERO) : new SqlBasicCall((SqlOperator)functions.iterator().next(), FunctionConverter.getFunctionParameters(segment.getParameters()), SqlParserPos.ZERO));
    }

    private static List<SqlNode> getFunctionParameters(Collection<ExpressionSegment> sqlSegments) {
        LinkedList<SqlNode> result = new LinkedList<SqlNode>();
        for (ExpressionSegment each : sqlSegments) {
            ExpressionConverter.convert(each).ifPresent(optional -> result.addAll(optional instanceof SqlNodeList ? ((SqlNodeList)optional).getList() : Collections.singleton(optional)));
        }
        return result;
    }

    @Generated
    private FunctionConverter() {
    }
}

