/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.session.connection.transaction;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.infra.session.connection.transaction.TransactionManager;

public final class TransactionConnectionContext
implements AutoCloseable {
    private volatile String transactionType;
    private volatile boolean inTransaction;
    private volatile long beginMills;
    private volatile boolean exceptionOccur;
    private volatile String readWriteSplitReplicaRoute;
    private AtomicReference<TransactionManager> transactionManager;

    public void beginTransaction(String transactionType, TransactionManager transactionManager) {
        this.transactionType = transactionType;
        this.inTransaction = true;
        this.transactionManager = new AtomicReference<TransactionManager>(transactionManager);
    }

    public boolean isInDistributedTransaction() {
        return this.inTransaction && ("XA".equals(this.transactionType) || "BASE".equals(this.transactionType));
    }

    public Optional<String> getTransactionType() {
        return Optional.ofNullable(this.transactionType);
    }

    public Optional<String> getReadWriteSplitReplicaRoute() {
        return Optional.ofNullable(this.readWriteSplitReplicaRoute);
    }

    public Optional<TransactionManager> getTransactionManager() {
        return null == this.transactionManager ? Optional.empty() : Optional.ofNullable(this.transactionManager.get());
    }

    @Override
    public void close() {
        this.transactionType = null;
        this.inTransaction = false;
        this.beginMills = 0L;
        this.exceptionOccur = false;
        this.readWriteSplitReplicaRoute = null;
        this.transactionManager = null;
    }

    @Generated
    public boolean isInTransaction() {
        return this.inTransaction;
    }

    @Generated
    public long getBeginMills() {
        return this.beginMills;
    }

    @Generated
    public boolean isExceptionOccur() {
        return this.exceptionOccur;
    }

    @Generated
    public void setBeginMills(long beginMills) {
        this.beginMills = beginMills;
    }

    @Generated
    public void setExceptionOccur(boolean exceptionOccur) {
        this.exceptionOccur = exceptionOccur;
    }

    @Generated
    public void setReadWriteSplitReplicaRoute(String readWriteSplitReplicaRoute) {
        this.readWriteSplitReplicaRoute = readWriteSplitReplicaRoute;
    }
}

