/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.checker.sql.util;

import java.util.Arrays;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;

public final class ShardingSupportedCheckUtils {
    public static boolean isSchemaContainsIndex(ShardingSphereSchema schema, IndexSegment index) {
        return schema.getAllTables().stream().anyMatch(each -> each.containsIndex(index.getIndexName().getIdentifier().getValue()));
    }

    public static boolean isShardingTablesNotBindingWithView(Collection<SimpleTableSegment> tableSegments, ShardingRule shardingRule, String viewName) {
        for (SimpleTableSegment each : tableSegments) {
            String logicTable = each.getTableName().getIdentifier().getValue();
            if (!shardingRule.isShardingTable(logicTable) || shardingRule.isAllConfigBindingTables(Arrays.asList(viewName, logicTable))) continue;
            return true;
        }
        return false;
    }

    public static boolean isRouteUnitDataNodeDifferentSize(ShardingRule shardingRule, RouteContext routeContext, String tableName) {
        return shardingRule.isShardingTable(tableName) && shardingRule.getShardingTable(tableName).getActualDataNodes().size() != routeContext.getRouteUnits().size();
    }

    @Generated
    private ShardingSupportedCheckUtils() {
    }
}

