/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.statement.ddl;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type.SimpleTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropIndexStatement;

public final class DropIndexStatementBinder
implements SQLStatementBinder<DropIndexStatement> {
    @Override
    public DropIndexStatement bind(DropIndexStatement sqlStatement, SQLStatementBinderContext binderContext) {
        if (!sqlStatement.getSimpleTable().isPresent()) {
            return sqlStatement;
        }
        DropIndexStatement result = DropIndexStatementBinder.copy(sqlStatement);
        LinkedHashMultimap tableBinderContexts = LinkedHashMultimap.create();
        result.setSimpleTable(SimpleTableSegmentBinder.bind((SimpleTableSegment)sqlStatement.getSimpleTable().get(), binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts));
        sqlStatement.getIndexes().forEach(each -> result.getIndexes().add(each));
        return result;
    }

    private static DropIndexStatement copy(DropIndexStatement sqlStatement) {
        DropIndexStatement result = (DropIndexStatement)sqlStatement.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        sqlStatement.getSimpleTable().ifPresent(arg_0 -> ((DropIndexStatement)result).setSimpleTable(arg_0));
        sqlStatement.getAlgorithmType().ifPresent(arg_0 -> ((DropIndexStatement)result).setAlgorithmType(arg_0));
        sqlStatement.getLockTable().ifPresent(arg_0 -> ((DropIndexStatement)result).setLockTable(arg_0));
        result.setIfExists(sqlStatement.isIfExists());
        result.addParameterMarkerSegments(sqlStatement.getParameterMarkerSegments());
        result.getCommentSegments().addAll(sqlStatement.getCommentSegments());
        result.getVariableNames().addAll(sqlStatement.getVariableNames());
        return result;
    }
}

