/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.dml;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.aware.ParameterAware;
import org.apache.shardingsphere.infra.binder.context.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.context.segment.insert.keygen.engine.GeneratedKeyContextEngine;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.InsertSelectContext;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.OnDuplicateUpdateContext;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.context.type.WhereAvailable;
import org.apache.shardingsphere.infra.binder.context.type.WithAvailable;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.statement.core.enums.SubqueryType;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.ColumnAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.OnDuplicateKeyColumnsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.combine.CombineSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.WithSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.InsertStatement;

public final class InsertStatementContext
extends CommonSQLStatementContext
implements TableAvailable,
ParameterAware,
WhereAvailable,
WithAvailable {
    private final ShardingSphereMetaData metaData;
    private final String currentDatabaseName;
    private final Map<String, Integer> insertColumnNamesAndIndexes;
    private final List<List<ExpressionSegment>> valueExpressions;
    private final TablesContext tablesContext;
    private final List<String> columnNames;
    private List<InsertValueContext> insertValueContexts;
    private InsertSelectContext insertSelectContext;
    private OnDuplicateUpdateContext onDuplicateKeyUpdateValueContext;
    private GeneratedKeyContext generatedKeyContext;

    public InsertStatementContext(ShardingSphereMetaData metaData, List<Object> params, InsertStatement sqlStatement, String currentDatabaseName) {
        super((SQLStatement)sqlStatement);
        this.metaData = metaData;
        this.currentDatabaseName = currentDatabaseName;
        this.valueExpressions = this.getAllValueExpressions(sqlStatement);
        AtomicInteger parametersOffset = new AtomicInteger(0);
        this.insertValueContexts = this.getInsertValueContexts(params, parametersOffset, this.valueExpressions);
        this.insertSelectContext = this.getInsertSelectContext(metaData, params, parametersOffset, currentDatabaseName).orElse(null);
        this.onDuplicateKeyUpdateValueContext = this.getOnDuplicateKeyUpdateValueContext(params, parametersOffset).orElse(null);
        this.tablesContext = new TablesContext(this.getAllSimpleTableSegments());
        List insertColumnNames = this.getInsertColumnNames();
        ShardingSphereSchema schema = this.getSchema(metaData, currentDatabaseName);
        this.columnNames = this.containsInsertColumns() ? insertColumnNames : sqlStatement.getTable().map(optional -> schema.getVisibleColumnNames(optional.getTableName().getIdentifier().getValue())).orElseGet(Collections::emptyList);
        this.insertColumnNamesAndIndexes = this.createInsertColumnNamesAndIndexes(insertColumnNames);
        this.generatedKeyContext = new GeneratedKeyContextEngine(sqlStatement, schema).createGenerateKeyContext(this.insertColumnNamesAndIndexes, this.insertValueContexts, params).orElse(null);
    }

    private Map<String, Integer> createInsertColumnNamesAndIndexes(List<String> insertColumnNames) {
        if (this.containsInsertColumns()) {
            CaseInsensitiveMap result = new CaseInsensitiveMap(insertColumnNames.size(), 1.0f);
            int index = 0;
            for (String each : insertColumnNames) {
                result.put(each, index++);
            }
            return result;
        }
        return Collections.emptyMap();
    }

    private List<InsertValueContext> getInsertValueContexts(List<Object> params, AtomicInteger paramsOffset, List<List<ExpressionSegment>> valueExpressions) {
        LinkedList<InsertValueContext> result = new LinkedList<InsertValueContext>();
        for (Collection collection : valueExpressions) {
            InsertValueContext insertValueContext = new InsertValueContext(collection, params, paramsOffset.get());
            result.add(insertValueContext);
            paramsOffset.addAndGet(insertValueContext.getParameterCount());
        }
        return result;
    }

    private Optional<InsertSelectContext> getInsertSelectContext(ShardingSphereMetaData metaData, List<Object> params, AtomicInteger paramsOffset, String currentDatabaseName) {
        if (!this.getSqlStatement().getInsertSelect().isPresent()) {
            return Optional.empty();
        }
        SubquerySegment insertSelectSegment = (SubquerySegment)this.getSqlStatement().getInsertSelect().get();
        SelectStatementContext selectStatementContext = new SelectStatementContext(metaData, params, insertSelectSegment.getSelect(), currentDatabaseName, Collections.emptyList());
        selectStatementContext.setSubqueryType(SubqueryType.INSERT_SELECT);
        this.setCombineSelectSubqueryType(selectStatementContext);
        this.setProjectionSelectSubqueryType(selectStatementContext);
        InsertSelectContext insertSelectContext = new InsertSelectContext(selectStatementContext, params, paramsOffset.get());
        paramsOffset.addAndGet(insertSelectContext.getParameterCount());
        return Optional.of(insertSelectContext);
    }

    private void setCombineSelectSubqueryType(SelectStatementContext selectStatementContext) {
        if (selectStatementContext.getSqlStatement().getCombine().isPresent()) {
            CombineSegment combineSegment = (CombineSegment)selectStatementContext.getSqlStatement().getCombine().get();
            Optional.ofNullable(selectStatementContext.getSubqueryContexts().get(combineSegment.getLeft().getStartIndex())).ifPresent(optional -> optional.setSubqueryType(SubqueryType.INSERT_SELECT));
            Optional.ofNullable(selectStatementContext.getSubqueryContexts().get(combineSegment.getRight().getStartIndex())).ifPresent(optional -> optional.setSubqueryType(SubqueryType.INSERT_SELECT));
        }
    }

    private void setProjectionSelectSubqueryType(SelectStatementContext selectStatementContext) {
        for (Map.Entry<Integer, SelectStatementContext> entry : selectStatementContext.getSubqueryContexts().entrySet()) {
            if (entry.getKey() < selectStatementContext.getProjectionsContext().getStartIndex() || entry.getKey() > selectStatementContext.getProjectionsContext().getStopIndex()) continue;
            entry.getValue().setSubqueryType(SubqueryType.INSERT_SELECT);
        }
    }

    private Optional<OnDuplicateUpdateContext> getOnDuplicateKeyUpdateValueContext(List<Object> params, AtomicInteger parametersOffset) {
        Optional onDuplicateKeyColumnsSegment = this.getSqlStatement().getOnDuplicateKeyColumns();
        if (!onDuplicateKeyColumnsSegment.isPresent()) {
            return Optional.empty();
        }
        Collection onDuplicateKeyColumns = ((OnDuplicateKeyColumnsSegment)onDuplicateKeyColumnsSegment.get()).getColumns();
        OnDuplicateUpdateContext onDuplicateUpdateContext = new OnDuplicateUpdateContext(onDuplicateKeyColumns, params, parametersOffset.get());
        parametersOffset.addAndGet(onDuplicateUpdateContext.getParameterCount());
        return Optional.of(onDuplicateUpdateContext);
    }

    private Collection<SimpleTableSegment> getAllSimpleTableSegments() {
        TableExtractor tableExtractor = new TableExtractor();
        tableExtractor.extractTablesFromInsert(this.getSqlStatement());
        return tableExtractor.getRewriteTables();
    }

    private ShardingSphereSchema getSchema(ShardingSphereMetaData metaData, String currentDatabaseName) {
        String databaseName = this.tablesContext.getDatabaseName().orElse(currentDatabaseName);
        ShardingSpherePreconditions.checkNotNull((Object)databaseName, NoDatabaseSelectedException::new);
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        ShardingSpherePreconditions.checkNotNull((Object)database, () -> new UnknownDatabaseException(databaseName));
        String defaultSchema = new DatabaseTypeRegistry(this.getDatabaseType()).getDefaultSchemaName(databaseName);
        return this.tablesContext.getSchemaName().map(arg_0 -> ((ShardingSphereDatabase)database).getSchema(arg_0)).orElseGet(() -> database.getSchema(defaultSchema));
    }

    public Iterator<String> getDescendingColumnNames() {
        return new LinkedList<String>(this.columnNames).descendingIterator();
    }

    public List<List<Object>> getGroupedParameters() {
        LinkedList<List<Object>> result = new LinkedList<List<Object>>();
        for (InsertValueContext each : this.insertValueContexts) {
            result.add(each.getParameters());
        }
        if (null != this.insertSelectContext && !this.insertSelectContext.getParameters().isEmpty()) {
            result.add(this.insertSelectContext.getParameters());
        }
        return result;
    }

    public List<Object> getOnDuplicateKeyUpdateParameters() {
        return null == this.onDuplicateKeyUpdateValueContext ? new ArrayList() : this.onDuplicateKeyUpdateValueContext.getParameters();
    }

    public Optional<GeneratedKeyContext> getGeneratedKeyContext() {
        return Optional.ofNullable(this.generatedKeyContext);
    }

    public boolean containsInsertColumns() {
        InsertStatement insertStatement = this.getSqlStatement();
        return !insertStatement.getColumns().isEmpty() || insertStatement.getSetAssignment().isPresent();
    }

    public int getValueListCount() {
        InsertStatement insertStatement = this.getSqlStatement();
        return insertStatement.getSetAssignment().isPresent() ? 1 : insertStatement.getValues().size();
    }

    public List<String> getInsertColumnNames() {
        return this.getSqlStatement().getSetAssignment().map(this::getColumnNamesForSetAssignment).orElseGet(() -> this.getColumnNamesForInsertColumns(this.getSqlStatement().getColumns()));
    }

    private List<String> getColumnNamesForSetAssignment(SetAssignmentSegment setAssignment) {
        LinkedList<String> result = new LinkedList<String>();
        for (ColumnAssignmentSegment each : setAssignment.getAssignments()) {
            result.add(((ColumnSegment)each.getColumns().get(0)).getIdentifier().getValue().toLowerCase());
        }
        return result;
    }

    private List<String> getColumnNamesForInsertColumns(Collection<ColumnSegment> columns) {
        LinkedList<String> result = new LinkedList<String>();
        for (ColumnSegment each : columns) {
            result.add(each.getIdentifier().getValue().toLowerCase());
        }
        return result;
    }

    private List<List<ExpressionSegment>> getAllValueExpressions(InsertStatement insertStatement) {
        Optional setAssignment = insertStatement.getSetAssignment();
        return setAssignment.map(optional -> Collections.singletonList(this.getAllValueExpressionsFromSetAssignment((SetAssignmentSegment)optional))).orElseGet(() -> this.getAllValueExpressionsFromValues(insertStatement.getValues()));
    }

    private List<ExpressionSegment> getAllValueExpressionsFromSetAssignment(SetAssignmentSegment setAssignment) {
        ArrayList<ExpressionSegment> result = new ArrayList<ExpressionSegment>(setAssignment.getAssignments().size());
        for (ColumnAssignmentSegment each : setAssignment.getAssignments()) {
            result.add(each.getValue());
        }
        return result;
    }

    private List<List<ExpressionSegment>> getAllValueExpressionsFromValues(Collection<InsertValuesSegment> values) {
        ArrayList<List<ExpressionSegment>> result = new ArrayList<List<ExpressionSegment>>(values.size());
        for (InsertValuesSegment each : values) {
            result.add(each.getValues());
        }
        return result;
    }

    public InsertStatement getSqlStatement() {
        return (InsertStatement)super.getSqlStatement();
    }

    @Override
    public void setUpParameters(List<Object> params) {
        AtomicInteger parametersOffset = new AtomicInteger(0);
        this.insertValueContexts = this.getInsertValueContexts(params, parametersOffset, this.valueExpressions);
        this.insertSelectContext = this.getInsertSelectContext(this.metaData, params, parametersOffset, this.currentDatabaseName).orElse(null);
        this.onDuplicateKeyUpdateValueContext = this.getOnDuplicateKeyUpdateValueContext(params, parametersOffset).orElse(null);
        ShardingSphereSchema schema = this.getSchema(this.metaData, this.currentDatabaseName);
        this.generatedKeyContext = new GeneratedKeyContextEngine(this.getSqlStatement(), schema).createGenerateKeyContext(this.insertColumnNamesAndIndexes, this.insertValueContexts, params).orElse(null);
    }

    @Override
    public Collection<WhereSegment> getWhereSegments() {
        return null == this.insertSelectContext ? Collections.emptyList() : this.insertSelectContext.getSelectStatementContext().getWhereSegments();
    }

    @Override
    public Collection<ColumnSegment> getColumnSegments() {
        return null == this.insertSelectContext ? Collections.emptyList() : this.insertSelectContext.getSelectStatementContext().getColumnSegments();
    }

    @Override
    public Collection<BinaryOperationExpression> getJoinConditions() {
        return null == this.insertSelectContext ? Collections.emptyList() : this.insertSelectContext.getSelectStatementContext().getJoinConditions();
    }

    @Override
    public Optional<WithSegment> getWith() {
        return this.getSqlStatement().getWithSegment();
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Generated
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Generated
    public List<InsertValueContext> getInsertValueContexts() {
        return this.insertValueContexts;
    }

    @Generated
    public InsertSelectContext getInsertSelectContext() {
        return this.insertSelectContext;
    }

    @Generated
    public OnDuplicateUpdateContext getOnDuplicateKeyUpdateValueContext() {
        return this.onDuplicateKeyUpdateValueContext;
    }
}

