/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.algorithm.cover;

import com.google.common.base.Strings;
import java.util.Properties;
import org.apache.shardingsphere.mask.algorithm.MaskAlgorithmPropertiesChecker;
import org.apache.shardingsphere.mask.spi.MaskAlgorithm;

public final class MaskAfterSpecialCharsAlgorithm
implements MaskAlgorithm<Object, String> {
    private static final String SPECIAL_CHARS = "special-chars";
    private static final String REPLACE_CHAR = "replace-char";
    private String specialChars;
    private Character replaceChar;

    public void init(Properties props) {
        this.specialChars = this.createSpecialChars(props);
        this.replaceChar = this.createReplaceChar(props);
    }

    private String createSpecialChars(Properties props) {
        MaskAlgorithmPropertiesChecker.checkAtLeastOneChar(props, SPECIAL_CHARS, this);
        return props.getProperty(SPECIAL_CHARS);
    }

    private Character createReplaceChar(Properties props) {
        MaskAlgorithmPropertiesChecker.checkSingleChar(props, REPLACE_CHAR, this);
        return Character.valueOf(props.getProperty(REPLACE_CHAR).charAt(0));
    }

    public String mask(Object plainValue) {
        String result;
        String string = result = null == plainValue ? null : String.valueOf(plainValue);
        if (Strings.isNullOrEmpty((String)result)) {
            return result;
        }
        int index = result.contains(this.specialChars) ? result.indexOf(this.specialChars) + this.specialChars.length() : -1;
        char[] chars = result.toCharArray();
        for (int i = index; i != -1 && i < chars.length; ++i) {
            chars[i] = this.replaceChar.charValue();
        }
        return new String(chars);
    }

    public String getType() {
        return "MASK_AFTER_SPECIAL_CHARS";
    }
}

